/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;

public class FirePropagate
implements Updatable {
    private static final int CELL_HEALTH = 10;
    private static final int CELL_ENERGY = 10;
    private final Map<Block, FireCellData> cells = new HashMap<Block, FireCellData>();
    private final Set<Block> visited = new HashSet<Block>();
    private int spreadingEnergy;

    private FirePropagate(int spreadingEnergy) {
        this.spreadingEnergy = FastMath.ceil(7.5 * (double)spreadingEnergy);
    }

    public boolean ignite(List<Block> blocks) {
        blocks.forEach(b -> this.trySpread((Block)b, (Block)b, this.cells));
        return !this.cells.isEmpty();
    }

    @Override
    public Updatable.UpdateResult update() {
        Iterator<Map.Entry<Block, FireCellData>> iterator = this.cells.entrySet().iterator();
        HashMap<Block, FireCellData> pending = new HashMap<Block, FireCellData>();
        block6: while (iterator.hasNext()) {
            Map.Entry<Block, FireCellData> entry = iterator.next();
            Block current = entry.getKey();
            switch (entry.getValue().updateState().ordinal()) {
                case 0: {
                    this.onDamage(current);
                    break;
                }
                case 1: {
                    for (Direction dir : WorldUtil.FACES) {
                        this.trySpread(current, current.offset(dir), pending);
                    }
                    continue block6;
                }
                case 2: {
                    this.onBurn(current);
                    break;
                }
                case 3: {
                    iterator.remove();
                    this.onRemove(current);
                }
            }
        }
        this.cells.putAll(pending);
        return this.cells.isEmpty() ? Updatable.UpdateResult.REMOVE : Updatable.UpdateResult.CONTINUE;
    }

    private void trySpread(Block from, Block to, Map<Block, FireCellData> map) {
        if (this.visited.add(to) && this.canSpread(to)) {
            map.put(to, new FireCellData(10, 10));
            this.onSpread(from, to);
            this.spreadingEnergy -= ThreadLocalRandom.current().nextInt(1, 10);
        }
    }

    protected void onDamage(Block block) {
        if (ThreadLocalRandom.current().nextInt(3) == 0) {
            Particle.SMALL_FLAME.builder(block.center()).count(4).offset(0.4).build();
        }
        if (ThreadLocalRandom.current().nextInt(4) == 0) {
            Particle.SMOKE.builder(block.center()).count(2).offset(0.4).build();
        }
    }

    protected boolean canSpread(Block block) {
        return this.spreadingEnergy > 0 && FirePropagate.canPropagate(block.type());
    }

    protected void onSpread(Block from, Block to) {
        for (int i = 0; i < 4; ++i) {
            Vector3d pos = VectorUtil.gaussianOffset(from.center(), 0.25);
            Vector3d dir = ((Vector3d)to.center().subtract(pos)).normalize();
            Particle.FLAME.builder(pos).count(0).offset(dir).extra(0.04).spawn(from.world());
        }
        if (ThreadLocalRandom.current().nextInt(4) == 0) {
            SoundEffect.FIRE.play(to);
        }
    }

    protected void onBurn(Block block) {
        Particle.FLAME.builder(block.center()).offset(0.2).spawn(block.world());
    }

    protected void onRemove(Block block) {
        TempBlock.air().build(block);
    }

    public static Optional<FirePropagate> create(int spreadingEnergy, List<Block> blocks) {
        FirePropagate instance = new FirePropagate(spreadingEnergy);
        return instance.ignite(blocks) ? Optional.of(instance) : Optional.empty();
    }

    public static boolean canPropagate(BlockType type) {
        return type == BlockType.COBWEB;
    }

    private static final class FireCellData {
        private int health;
        private int energy;

        private FireCellData(int maxHealth, int energy) {
            this.health = maxHealth;
            this.energy = energy;
        }

        private State updateState() {
            if (this.health > 0) {
                --this.health;
                if (this.health <= 0) {
                    return State.SPREAD_TO_NEIGHBOURS;
                }
                return State.DAMAGE_SELF;
            }
            if (this.energy > 0) {
                --this.energy;
                return State.BURN;
            }
            return State.REMOVE;
        }
    }

    private static enum State {
        DAMAGE_SELF,
        SPREAD_TO_NEIGHBOURS,
        BURN,
        REMOVE;

    }
}

