/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util.material;

import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockStateProperties;
import me.moros.bending.api.platform.block.BlockTag;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemTag;
import me.moros.bending.api.platform.property.Property;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import net.kyori.adventure.key.Key;

public final class MaterialUtil {
    public static final BlockTag WATER_PLANTS = BlockTag.reference(KeyUtil.simple("water_plants"));
    public static final BlockTag BREAKABLE_PLANTS = BlockTag.reference(KeyUtil.simple("breakable_plants"));
    public static final BlockTag TRANSPARENT = BlockTag.reference(KeyUtil.simple("transparent"));
    public static final BlockTag LOCKABLE_CONTAINERS = BlockTag.reference(KeyUtil.simple("lockable_containers"));
    public static final BlockTag CONTAINERS = BlockTag.reference(KeyUtil.simple("containers"));
    public static final BlockTag UNBREAKABLES = BlockTag.reference(KeyUtil.simple("unbreakable"));
    public static final ItemTag METAL_ARMOR = ItemTag.reference(KeyUtil.simple("metal_armor"));
    private static final BlockTag STAINED_TERRACOTTA = BlockTag.builder("stained_terracotta").endsWith("terracotta").not(BlockType.TERRACOTTA).notEndsWith("glazed_terracotta").build();
    private static final BlockTag SANDSTONES = (BlockTag)BlockTag.builder("sandstone").add(BlockType.SANDSTONE, new BlockType[]{BlockType.CHISELED_SANDSTONE, BlockType.CUT_SANDSTONE, BlockType.SMOOTH_SANDSTONE}).build();
    private static final BlockTag RED_SANDSTONES = BlockTag.builder("red_sandstone").endsWith("red_sandstone").build();
    private static final BlockTag TO_GRAVEL = (BlockTag)BlockTag.builder("soft-to-gravel").add(BlockType.STONE, new BlockType[]{BlockType.GRANITE, BlockType.POLISHED_GRANITE, BlockType.DIORITE, BlockType.POLISHED_DIORITE, BlockType.ANDESITE, BlockType.POLISHED_ANDESITE, BlockType.GRAVEL, BlockType.DEEPSLATE, BlockType.CALCITE, BlockType.TUFF, BlockType.SMOOTH_BASALT}).build();
    private static final BlockTag TO_DIRT = (BlockTag)BlockTag.builder("soft-to-dirt").add(BlockType.DIRT, new BlockType[]{BlockType.MYCELIUM, BlockType.GRASS_BLOCK, BlockType.DIRT_PATH, BlockType.PODZOL, BlockType.COARSE_DIRT, BlockType.ROOTED_DIRT}).build();

    private MaterialUtil() {
    }

    public static void init() {
        BlockTag.builder(WATER_PLANTS.key()).add(BlockTag.reference(KeyUtil.simple("extra_water_plants"))).add(BlockType.SEAGRASS, new BlockType[]{BlockType.TALL_SEAGRASS, BlockType.KELP, BlockType.KELP_PLANT}).buildAndRegister();
        BlockTag.builder(BREAKABLE_PLANTS.key()).add(BlockTag.reference(KeyUtil.simple("extra_breakable_plants"))).add(WATER_PLANTS).add(BlockTag.SAPLINGS).add(BlockTag.FLOWERS).add(BlockTag.CROPS).add(BlockTag.CAVE_VINES).add(BlockTag.CORALS).add(BlockType.BROWN_MUSHROOM, new BlockType[]{BlockType.RED_MUSHROOM}).add(BlockTag.CORALS).add(BlockTag.CORAL_BLOCKS).add(BlockType.SHORT_GRASS, new BlockType[]{BlockType.TALL_GRASS, BlockType.LARGE_FERN, BlockType.GLOW_LICHEN, BlockType.WEEPING_VINES, BlockType.WEEPING_VINES_PLANT, BlockType.TWISTING_VINES, BlockType.TWISTING_VINES_PLANT, BlockType.VINE, BlockType.FERN, BlockType.SUGAR_CANE, BlockType.DEAD_BUSH, BlockType.SMALL_DRIPLEAF, BlockType.BIG_DRIPLEAF, BlockType.BIG_DRIPLEAF_STEM}).buildAndRegister();
        BlockTag.builder(TRANSPARENT.key()).add(BlockTag.reference(KeyUtil.simple("extra_transparent"))).add(BREAKABLE_PLANTS).add(BlockTag.SIGNS).add(BlockTag.FIRE).add(BlockTag.WOOL_CARPETS).add(BlockTag.BUTTONS).add(BlockType.LIGHT, new BlockType[]{BlockType.AIR, BlockType.CAVE_AIR, BlockType.VOID_AIR, BlockType.COBWEB, BlockType.SNOW}).endsWith("torch").buildAndRegister();
        BlockTag.builder(LOCKABLE_CONTAINERS.key()).add(BlockTag.reference(KeyUtil.simple("extra_lockable_containers"))).add(BlockTag.COPPER_CHESTS).add(BlockType.CHEST, new BlockType[]{BlockType.TRAPPED_CHEST, BlockType.BARREL, BlockType.SHULKER_BOX, BlockType.FURNACE, BlockType.BLAST_FURNACE, BlockType.SMOKER, BlockType.BEACON, BlockType.DISPENSER, BlockType.DROPPER, BlockType.HOPPER, BlockType.BREWING_STAND}).buildAndRegister();
        BlockTag.builder(CONTAINERS.key()).add(BlockTag.reference(KeyUtil.simple("extra_containers"))).add(LOCKABLE_CONTAINERS).add(BlockType.ENDER_CHEST, new BlockType[]{BlockType.ENCHANTING_TABLE, BlockType.ANVIL, BlockType.CHIPPED_ANVIL, BlockType.DAMAGED_ANVIL, BlockType.GRINDSTONE, BlockType.CARTOGRAPHY_TABLE, BlockType.LOOM, BlockType.SMITHING_TABLE, BlockType.JUKEBOX}).buildAndRegister();
        BlockTag.builder(UNBREAKABLES.key()).add(BlockTag.reference(KeyUtil.simple("extra_unbreakables"))).add(BlockType.BARRIER, new BlockType[]{BlockType.BEDROCK, BlockType.OBSIDIAN, BlockType.CRYING_OBSIDIAN, BlockType.NETHER_PORTAL, BlockType.END_PORTAL, BlockType.END_PORTAL_FRAME, BlockType.END_GATEWAY}).buildAndRegister();
        ItemTag.builder(METAL_ARMOR.key()).add(ItemTag.reference(KeyUtil.simple("extra_metal_armor"))).add(Item.IRON_HELMET, new Item[]{Item.IRON_CHESTPLATE, Item.IRON_LEGGINGS, Item.IRON_BOOTS, Item.GOLDEN_HELMET, Item.GOLDEN_CHESTPLATE, Item.GOLDEN_LEGGINGS, Item.GOLDEN_BOOTS, Item.COPPER_HELMET, Item.COPPER_CHESTPLATE, Item.COPPER_LEGGINGS, Item.COPPER_BOOTS, Item.CHAINMAIL_HELMET, Item.CHAINMAIL_CHESTPLATE, Item.CHAINMAIL_LEGGINGS, Item.CHAINMAIL_BOOTS, Item.NETHERITE_HELMET, Item.NETHERITE_CHESTPLATE, Item.NETHERITE_LEGGINGS, Item.NETHERITE_BOOTS}).buildAndRegister();
    }

    public static boolean isAir(Block block) {
        return block.type().isAir();
    }

    public static boolean isTransparent(Block block) {
        return TRANSPARENT.isTagged(block);
    }

    public static boolean isTransparentOrWater(Block block) {
        return TRANSPARENT.isTagged(block) || MaterialUtil.isWater(block);
    }

    public static boolean isUnbreakable(Block block) {
        return UNBREAKABLES.isTagged(block) || CONTAINERS.isTagged(block) || block.world().isBlockEntity(block);
    }

    public static boolean isIgnitable(Block block) {
        if (block.type().isFlammable() && MaterialUtil.isTransparent(block)) {
            return true;
        }
        return MaterialUtil.isAir(block) && block.offset(Direction.DOWN).type().isSolid();
    }

    public static boolean isFire(BlockType type) {
        return BlockTag.FIRE.isTagged(type);
    }

    public static boolean isFire(Block block) {
        return BlockTag.FIRE.isTagged(block);
    }

    public static boolean isCampfire(Block block) {
        return BlockTag.CAMPFIRES.isTagged(block);
    }

    public static boolean isLava(Block block) {
        return block.type() == BlockType.LAVA;
    }

    public static boolean isWaterPlant(Block block) {
        return WATER_PLANTS.isTagged(block);
    }

    public static boolean isWater(Block block) {
        BlockType type = block.type();
        if (type == BlockType.WATER || type == BlockType.BUBBLE_COLUMN) {
            return true;
        }
        return MaterialUtil.isWaterLogged(block) || MaterialUtil.isWaterPlant(block);
    }

    public static boolean isWaterLogged(Block block) {
        Boolean property = (Boolean)block.state().property(BlockStateProperties.WATERLOGGED);
        return Boolean.TRUE.equals(property);
    }

    public static boolean isMeltable(Block block) {
        return WaterMaterials.isSnowBendable(block) || WaterMaterials.isIceBendable(block);
    }

    public static BlockType solidType(BlockType type) {
        return MaterialUtil.solidType(type, type);
    }

    public static BlockType solidType(BlockType type, BlockType def) {
        if (type.name().endsWith("_concrete_powder")) {
            BlockType result = BlockType.registry().fromString(type.name().replace("_powder", ""));
            return result == null ? def : result;
        }
        if (type == BlockType.SAND) {
            return BlockType.SANDSTONE;
        }
        if (type == BlockType.RED_SAND) {
            return BlockType.RED_SANDSTONE;
        }
        if (type == BlockType.GRAVEL) {
            return BlockType.STONE;
        }
        return def;
    }

    public static BlockType focusedType(BlockType type) {
        return type == BlockType.STONE ? BlockType.COBBLESTONE : MaterialUtil.solidType(type, BlockType.STONE);
    }

    public static BlockType softType(BlockType type) {
        if (type == BlockType.SAND || SANDSTONES.isTagged(type)) {
            return BlockType.SAND;
        }
        if (type == BlockType.RED_SAND || RED_SANDSTONES.isTagged(type)) {
            return BlockType.RED_SAND;
        }
        if (STAINED_TERRACOTTA.isTagged(type)) {
            return BlockType.CLAY;
        }
        if (type.name().endsWith("_concrete")) {
            BlockType result = BlockType.registry().get(Key.key((String)type.key().namespace(), (String)(type.name() + "_powder")));
            return result == null ? BlockType.GRAVEL : result;
        }
        if (type.name().endsWith("_ore")) {
            return BlockType.GRAVEL;
        }
        if (TO_GRAVEL.isTagged(type)) {
            return BlockType.GRAVEL;
        }
        if (TO_DIRT.isTagged(type)) {
            return BlockType.COARSE_DIRT;
        }
        return BlockType.SAND;
    }

    public static boolean isSourceBlock(Block block) {
        Integer level = (Integer)block.state().property(BlockStateProperties.LEVEL);
        return level != null && level == 0;
    }

    public static BlockState lavaData(int level) {
        return BlockType.LAVA.defaultState().withProperty((Property)BlockStateProperties.LEVEL, Integer.valueOf(Math.clamp((long)level, 0, 15)));
    }

    public static BlockState waterData(int level) {
        return BlockType.WATER.defaultState().withProperty((Property)BlockStateProperties.LEVEL, Integer.valueOf(Math.clamp((long)level, 0, 15)));
    }
}

