/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util.functional;

import java.util.function.Supplier;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.math.Vector3d;
import org.jspecify.annotations.Nullable;

public final class OutOfRangeRemovalPolicy
implements RemovalPolicy {
    private final double rangeSq;
    private final Vector3d origin;
    private final Supplier<Vector3d> supplier;

    private OutOfRangeRemovalPolicy(double range, @Nullable Vector3d origin, Supplier<Vector3d> supplier) {
        this.rangeSq = range * range;
        this.origin = origin;
        this.supplier = supplier;
    }

    @Override
    public boolean test(User user, AbilityDescription desc) {
        return this.supplier.get().distanceSq(this.origin == null ? user.eyeLocation() : this.origin) > this.rangeSq;
    }

    public static RemovalPolicy of(double range, Supplier<Vector3d> supplier) {
        return OutOfRangeRemovalPolicy.of(range, null, supplier);
    }

    public static RemovalPolicy of(double range, @Nullable Vector3d origin, Supplier<Vector3d> supplier) {
        if (range == 0.0) {
            return (u, d) -> false;
        }
        return new OutOfRangeRemovalPolicy(range, origin, supplier);
    }
}

