/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util.collect;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.util.collect.ElementSet;
import me.moros.bending.api.util.collect.MutableElementSet;

final class ImmutableElementSet
extends AbstractSet<Element>
implements ElementSet {
    private static final int SPLITERATOR_CHARACTERISTICS = 17749;
    static final ElementSet EMPTY = new ImmutableElementSet(0);
    private final int elements;

    private ImmutableElementSet(int elements) {
        this.elements = elements;
    }

    static ElementSet from(int value) {
        return value == 0 ? EMPTY : new ImmutableElementSet(value);
    }

    @Override
    public int elements() {
        return this.elements;
    }

    @Override
    public int size() {
        return Integer.bitCount(this.elements);
    }

    @Override
    public boolean isEmpty() {
        return this.elements == 0;
    }

    @Override
    public boolean contains(Object e) {
        if (e == null || e.getClass() != Element.class) {
            return false;
        }
        return (this.elements & 1 << ((Element)((Object)e)).ordinal()) != 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        ElementSet other;
        return c instanceof ElementSet ? ((other = (ElementSet)c).elements() & ~this.elements) == 0 : super.containsAll(c);
    }

    @Override
    public Iterator<Element> iterator() {
        return new MutableElementSet.Itr(this.elements);
    }

    @Override
    public Spliterator<Element> spliterator() {
        return Spliterators.spliterator(this, 17749);
    }

    @Override
    public boolean equals(Object obj) {
        ElementSet other;
        return obj instanceof ElementSet ? (other = (ElementSet)obj).elements() == this.elements : super.equals(obj);
    }

    @Override
    public boolean set(Set<Element> other) {
        throw ImmutableElementSet.uoe();
    }

    @Override
    public boolean add(Element e) {
        throw ImmutableElementSet.uoe();
    }

    @Override
    public boolean addAll(Collection<? extends Element> c) {
        throw ImmutableElementSet.uoe();
    }

    @Override
    public void clear() {
        throw ImmutableElementSet.uoe();
    }

    @Override
    public boolean remove(Object o) {
        throw ImmutableElementSet.uoe();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw ImmutableElementSet.uoe();
    }

    @Override
    public boolean removeIf(Predicate<? super Element> filter) {
        throw ImmutableElementSet.uoe();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw ImmutableElementSet.uoe();
    }

    private static UnsupportedOperationException uoe() {
        return new UnsupportedOperationException();
    }
}

