/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.moros.bending.api.event.TickEffectEvent;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.entity.EntityUtil;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.platform.property.IntegerProperty;
import me.moros.bending.api.user.User;
import me.moros.math.FastMath;
import org.jspecify.annotations.Nullable;

public enum BendingEffect {
    FROST_TICK(135, true, 140, EntityProperties.FREEZE_TICKS),
    FIRE_TICK(15, false, 100, EntityProperties.FIRE_TICKS);

    public static final int MAX_BLOCK_FIRE_TICKS = 100;
    private final Map<LivingEntity, User> instances = new ConcurrentHashMap<LivingEntity, User>();
    private final int visual;
    private final boolean cumulative;
    private final int maxTicks;
    private final IntegerProperty property;

    private BendingEffect(int visual, boolean cumulative, int maxTicks, IntegerProperty property) {
        this.visual = visual;
        this.cumulative = cumulative;
        this.maxTicks = maxTicks;
        this.property = property;
    }

    private int getCurrentTicks(Entity entity) {
        return entity.propertyValue(this.property);
    }

    private void setCurrentTicks(Entity entity, int value) {
        entity.setProperty(this.property, value);
    }

    public void apply(User source, Entity entity) {
        this.apply(source, entity, this.visual);
    }

    public void apply(User source, Entity entity, int ticks) {
        if (ticks <= 0) {
            return;
        }
        TickEffectEvent event = source.game().eventBus().postTickEffectEvent(source, entity, ticks, this);
        int duration = event.duration();
        if (event.cancelled() || duration <= 0) {
            return;
        }
        int current = Math.max(0, this.getCurrentTicks(entity));
        int ticksToApply = 0;
        if (this.cumulative) {
            ticksToApply = current + duration;
        } else if (current < duration) {
            ticksToApply = duration;
        }
        ticksToApply = Math.clamp((long)ticksToApply, 0, this.maxTicks);
        if (ticksToApply > 0) {
            this.setCurrentTicks(entity, ticksToApply);
            this.trackEntity(entity, source);
        }
        if (this == FROST_TICK) {
            this.handleFreeze(entity, ticksToApply);
        }
    }

    private void handleFreeze(Entity entity, int duration) {
        if (duration >= 30 && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            int potionDuration = FastMath.round(0.5 * (double)duration);
            int power = FastMath.floor((double)duration / 30.0);
            EntityUtil.tryAddPotion(living, PotionEffect.SLOWNESS, potionDuration, power);
        }
    }

    public void reset(Entity entity) {
        this.setCurrentTicks(entity, -1);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.instances.remove(livingEntity);
        }
    }

    public @Nullable User tickSource(LivingEntity entity) {
        return this.instances.get(entity);
    }

    private void trackEntity(Entity entity, User source) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.instances.put(livingEntity, source);
        }
    }

    public static void cleanup() {
        for (BendingEffect tick : BendingEffect.values()) {
            tick.instances.keySet().removeIf(e -> !e.valid() || tick.getCurrentTicks((Entity)e) <= 0);
        }
    }

    public static void resetAll(Entity entity) {
        for (BendingEffect tick : BendingEffect.values()) {
            tick.reset(entity);
        }
    }
}

