/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.user.profile;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.ability.preset.Preset;
import me.moros.bending.api.user.profile.BenderProfileImpl;
import me.moros.bending.api.util.collect.ElementSet;

public sealed interface BenderProfile
permits BenderProfileImpl {
    public UUID uuid();

    public boolean board();

    public Preset slots();

    public ElementSet elements();

    public Map<String, Preset> presets();

    public static BenderProfile of(UUID uuid) {
        return new BenderProfileImpl(uuid, true, ElementSet.of(), Preset.empty(), Map.of());
    }

    public static BenderProfile of(UUID uuid, Collection<Element> elements, Preset slots, Collection<Preset> presets) {
        return BenderProfile.of(uuid, true, elements, slots, presets);
    }

    public static BenderProfile of(UUID uuid, boolean board, Collection<Element> elements, Preset slots, Collection<Preset> presets) {
        Objects.requireNonNull(uuid);
        ElementSet elementsCopy = ElementSet.copyOf(elements);
        LinkedHashMap map = new LinkedHashMap();
        presets.stream().filter(p -> !p.name().isEmpty() && !p.isEmpty()).sorted(Comparator.comparing(Preset::name)).forEach(p -> map.put(p.name(), p));
        return new BenderProfileImpl(uuid, board, elementsCopy, slots.withName(""), Collections.unmodifiableMap(map));
    }
}

