/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.user;

import java.util.function.Predicate;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.preset.Preset;
import org.jspecify.annotations.Nullable;

final class SlotContainer {
    private volatile transient AbilityDescription[] slots;
    private volatile transient Preset presetRepresentation;
    private final transient Object lock = new Object();

    SlotContainer() {
        this.slots = new AbilityDescription[9];
        this.presetRepresentation = Preset.empty();
    }

    AbilityDescription[] getArray() {
        return this.slots;
    }

    private void setArray(AbilityDescription[] array) {
        this.slots = array;
        this.presetRepresentation = Preset.from(this.getArray());
    }

    @Nullable AbilityDescription get(int idx) {
        return this.getArray()[idx];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(int idx, @Nullable AbilityDescription desc) {
        Object object = this.lock;
        synchronized (object) {
            AbilityDescription[] arr = this.getArray();
            if (arr[idx] != desc) {
                arr = (AbilityDescription[])arr.clone();
                arr[idx] = desc;
            }
            this.setArray(arr);
        }
    }

    Preset toPreset() {
        return this.presetRepresentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fromPreset(Preset preset, Predicate<AbilityDescription> predicate) {
        AbilityDescription[] copy = new AbilityDescription[9];
        preset.copyTo(copy);
        for (int idx = 0; idx < copy.length; ++idx) {
            AbilityDescription target = copy[idx];
            copy[idx] = target != null && predicate.test(target) ? target : null;
        }
        Object object = this.lock;
        synchronized (object) {
            this.setArray(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate(Predicate<AbilityDescription> predicate) {
        AbilityDescription[] arr = this.getArray();
        for (int idx = 0; idx < arr.length; ++idx) {
            AbilityDescription desc = arr[idx];
            if (desc == null || predicate.test(desc)) continue;
            arr[idx] = null;
        }
        Object object = this.lock;
        synchronized (object) {
            this.setArray(arr);
        }
    }
}

