/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.temporal;

import java.util.List;
import java.util.Optional;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockStateProperties;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.property.Property;
import me.moros.bending.api.platform.property.PropertyHolder;
import me.moros.bending.api.temporal.TemporalManager;
import me.moros.bending.api.temporal.Temporary;

public final class TempLight
extends Temporary {
    public static final TemporalManager<Block, TempLight> MANAGER = new TemporalManager<Block, TempLight>(600){

        @Override
        public void tick() {
            List<TempLight> toRemove = MANAGER.stream().filter(TempLight::tick).toList();
            toRemove.forEach(TempLight::revertFully);
            super.tick();
        }
    };
    private final Block block;
    private int level;
    private final int rate;
    private boolean lock = false;
    private boolean reverted = false;
    private Type lastType;
    private boolean skipTick = false;

    private TempLight(Block block, int level, int rate, int ticks, Type type) {
        this.block = block;
        this.level = level;
        this.rate = rate;
        this.lastType = type;
        this.render();
        MANAGER.addEntry(block, this, ticks);
    }

    @Override
    public boolean revert() {
        if (this.reverted) {
            return false;
        }
        this.revertFully();
        return true;
    }

    private void revertFully() {
        if (!this.reverted) {
            Platform.instance().nativeAdapter().fakeBlock(this.block, this.block.state()).broadcast(this.block.world(), this.block);
            MANAGER.removeEntry(this.block);
            this.reverted = true;
        }
    }

    private boolean tick() {
        this.skipTick ^= true;
        if (this.lock || this.reverted || this.skipTick) {
            return false;
        }
        this.level -= this.rate;
        if (this.level > 0) {
            this.lastType = TempLight.isValid(this.block, this.level);
            if (this.lastType != Type.INVALID) {
                this.render();
                return false;
            }
        }
        return true;
    }

    private void render() {
        boolean waterlogged = this.lastType == Type.WATER;
        PropertyHolder state = BlockType.LIGHT.defaultState().withProperty((Property)BlockStateProperties.LEVEL, Integer.valueOf(this.level));
        if (waterlogged) {
            state = state.withProperty((Property)BlockStateProperties.WATERLOGGED, Boolean.valueOf(true));
        }
        Platform.instance().nativeAdapter().fakeBlock(this.block, (BlockState)state).broadcast(this.block.world(), this.block);
    }

    public TempLight lock() {
        this.lock = true;
        return this;
    }

    public void unlock() {
        this.lock = false;
    }

    public Block block() {
        return this.block;
    }

    public int level() {
        return this.level;
    }

    private static Type isValid(Block block, int level) {
        if (block.world().lightLevel(block) < level) {
            Integer property;
            BlockState state = block.state();
            BlockType mat = state.type();
            if (mat.isAir()) {
                return Type.NORMAL;
            }
            if (mat == BlockType.WATER && (property = (Integer)state.property(BlockStateProperties.LEVEL)) != null && property == 0) {
                return Type.WATER;
            }
        }
        return Type.INVALID;
    }

    public static Builder builder(int level) {
        return new Builder(Math.clamp((long)level, 1, BlockStateProperties.LEVEL.max()));
    }

    private static enum Type {
        NORMAL,
        WATER,
        INVALID;

    }

    public static final class Builder {
        private final int level;
        private int rate = 3;
        private long duration = 750L;

        private Builder(int level) {
            this.level = level;
        }

        public Builder rate(int rate) {
            this.rate = Math.max(1, rate);
            return this;
        }

        public Builder duration(long duration) {
            this.duration = duration <= 0L || duration > 30000L ? 30000L : duration;
            return this;
        }

        public Optional<TempLight> build(Block block) {
            if (!BendingProperties.instance().canGenerateLight()) {
                return Optional.empty();
            }
            Type type = TempLight.isValid(block, this.level);
            if (type == Type.INVALID) {
                return Optional.empty();
            }
            TempLight light = MANAGER.get(block).orElse(null);
            if (light != null) {
                if (light.level < this.level) {
                    light.level = this.level;
                    light.lastType = type;
                    light.render();
                }
                return Optional.of(light);
            }
            return Optional.of(new TempLight(block, this.level, this.rate, MANAGER.fromMillis(this.duration), type));
        }
    }
}

