/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.temporal;

import java.util.Objects;
import java.util.Set;
import me.moros.bending.api.adapter.PacketUtil;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.entity.DelegateEntity;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.temporal.TempEntityBuilder;
import me.moros.bending.api.temporal.TemporalManager;
import me.moros.bending.api.temporal.Temporary;
import me.moros.math.Vector3d;
import org.jspecify.annotations.Nullable;

public class TempEntity
extends Temporary {
    public static final TemporalManager<Integer, TempEntity> MANAGER = new TemporalManager(600);
    private final TempEntityData data;
    private boolean reverted = false;

    private TempEntity(TempEntityData data, int ticks) {
        this.data = data;
        MANAGER.addEntry(data.id, this, ticks);
    }

    @Override
    public boolean revert() {
        if (this.reverted) {
            return false;
        }
        this.reverted = true;
        MANAGER.removeEntry(this.data.destroy());
        return true;
    }

    protected boolean isReverted() {
        return this.reverted;
    }

    public static FallingBlockBuilder fallingBlock(BlockState data) {
        return new FallingBlockBuilder(Objects.requireNonNull(data));
    }

    private record TempEntityData(int id, @Nullable Entity entity) {
        private TempEntityData(int id) {
            this(id, null);
        }

        private TempEntityData(Entity entity) {
            this(entity.id(), entity);
        }

        private int destroy() {
            if (this.entity != null) {
                this.entity.remove();
            } else {
                Platform.instance().nativeAdapter().destroy(this.id);
            }
            return this.id;
        }
    }

    public static final class FallingBlockBuilder
    extends TempEntityBuilder<BlockState, TempEntity, FallingBlockBuilder> {
        private static final Vector3d FALLING_BLOCK_OFFSET = Vector3d.of(0.5, 0.0, 0.5);

        private FallingBlockBuilder(BlockState data) {
            super(data);
        }

        public TempFallingBlock buildReal(Block block) {
            return this.buildReal(block.world(), (Vector3d)block.toVector3d().add(FALLING_BLOCK_OFFSET));
        }

        public TempFallingBlock buildReal(World world, Vector3d center) {
            return this.spawnReal(world, center);
        }

        public TempEntity build(Block block) {
            return this.build(block.world(), (Vector3d)block.toVector3d().add(FALLING_BLOCK_OFFSET));
        }

        @Override
        public TempEntity build(World world, Vector3d center) {
            PacketUtil.ClientboundPacket packet = Platform.instance().nativeAdapter().createFallingBlock(center, (BlockState)this.data, this.velocity, this.gravity);
            if (packet.id() > 0) {
                if (this.viewers.isEmpty()) {
                    packet.broadcast(world, center);
                } else {
                    packet.send(Set.copyOf(this.viewers));
                }
                return new TempEntity(new TempEntityData(packet.id()), MANAGER.fromMillis(this.duration));
            }
            return this.spawnReal(world, center);
        }

        private TempFallingBlock spawnReal(World world, Vector3d center) {
            Entity entity = world.createFallingBlock(center, (BlockState)this.data, this.gravity);
            entity.velocity(this.velocity);
            return new TempFallingBlock(entity, (BlockState)this.data, MANAGER.fromMillis(this.duration));
        }
    }

    public static final class TempFallingBlock
    extends TempEntity
    implements DelegateEntity {
        private final Entity fallingBlock;
        private final BlockState state;

        private TempFallingBlock(Entity fallingBlock, BlockState state, int ticks) {
            super(new TempEntityData(fallingBlock), ticks);
            this.fallingBlock = fallingBlock;
            this.state = state;
        }

        @Override
        public Entity entity() {
            return this.fallingBlock;
        }

        public BlockState state() {
            return this.state;
        }

        @Override
        public Vector3d center() {
            return this.fallingBlock.location().add(0.0, 0.5, 0.0);
        }

        @Override
        public boolean valid() {
            return !this.isReverted();
        }
    }
}

