/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.temporal;

import java.util.Objects;
import java.util.UUID;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.temporal.TemporalManager;
import me.moros.bending.api.temporal.Temporary;
import me.moros.bending.api.user.User;
import org.jspecify.annotations.Nullable;

public final class Cooldown
extends Temporary {
    public static final TemporalManager<Cooldown, Cooldown> MANAGER = new TemporalManager(2400, false);
    private final UUID uuid;
    private final AbilityDescription desc;
    private final Runnable runnable;
    private boolean reverted = false;
    private final int hashCode;

    private Cooldown(UUID uuid, AbilityDescription desc, @Nullable Runnable runnable) {
        this.uuid = uuid;
        this.desc = desc;
        this.runnable = runnable;
        this.hashCode = Objects.hash(this.uuid, this.desc);
    }

    private Cooldown(UUID uuid, AbilityDescription desc, Runnable runnable, int ticks) {
        this(uuid, desc, runnable);
        MANAGER.addEntry(this, this, ticks);
    }

    @Override
    public boolean revert() {
        if (this.reverted) {
            return false;
        }
        this.reverted = true;
        MANAGER.removeEntry(this);
        if (this.runnable != null) {
            this.runnable.run();
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Cooldown) {
            Cooldown other = (Cooldown)obj;
            return this.uuid.equals(other.uuid) && this.desc.equals(other.desc);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static Cooldown of(User user, AbilityDescription desc) {
        return new Cooldown(user.uuid(), desc, null);
    }

    public static Cooldown of(User user, AbilityDescription desc, Runnable runnable, long duration) {
        return new Cooldown(user.uuid(), desc, runnable, MANAGER.fromMillis(duration));
    }
}

