/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import me.moros.bending.api.registry.MutableRegistry;
import me.moros.bending.api.registry.Registry;
import me.moros.bending.api.registry.RegistryModificationException;
import me.moros.bending.api.registry.Tag;
import me.moros.bending.api.util.data.DataKey;
import net.kyori.adventure.key.Key;
import org.jspecify.annotations.Nullable;

public class SimpleRegistry<K, V>
implements Registry<K, V> {
    private final DataKey<V> key;
    protected final Map<K, V> registryMap;
    protected final Map<Key, Tag<V>> tags;
    protected final Function<V, K> inverseMapper;
    protected final Function<String, K> keyMapper;
    protected boolean locked = false;

    protected SimpleRegistry(DataKey<V> key, Function<V, K> inverseMapper, Function<String, K> keyMapper) {
        this.key = key;
        this.inverseMapper = inverseMapper;
        this.keyMapper = keyMapper;
        this.registryMap = new ConcurrentHashMap();
        this.tags = new ConcurrentHashMap<Key, Tag<V>>();
    }

    private Collection<V> values() {
        return this.registryMap.values();
    }

    @Override
    public DataKey<V> key() {
        return this.key;
    }

    @Override
    public boolean register(V value) {
        this.checkLock();
        K key = this.inverseMapper.apply(value);
        return this.registryMap.putIfAbsent(key, value) == null;
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    protected void checkLock() {
        if (this.isLocked()) {
            throw new RegistryModificationException("Registry " + this.key.asString() + " is locked.");
        }
    }

    @Override
    public boolean containsKey(K key) {
        return this.registryMap.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        Objects.requireNonNull(value);
        return this.containsKey(this.inverseMapper.apply(value));
    }

    @Override
    public @Nullable V get(K key) {
        return this.registryMap.get(key);
    }

    @Override
    public @Nullable V fromString(String input) {
        Objects.requireNonNull(input);
        K key = this.keyMapper.apply(input.toLowerCase(Locale.ROOT));
        return key == null ? null : (V)this.get(key);
    }

    @Override
    public int size() {
        return this.registryMap.size();
    }

    @Override
    public Stream<V> stream() {
        return this.values().stream();
    }

    @Override
    public Stream<K> streamKeys() {
        return this.registryMap.keySet().stream();
    }

    @Override
    public Set<K> keys() {
        return Set.copyOf(this.registryMap.keySet());
    }

    @Override
    public Iterator<V> iterator() {
        return Collections.unmodifiableCollection(this.values()).iterator();
    }

    @Override
    public @Nullable Tag<V> getTag(Key key) {
        return this.tags.get(key);
    }

    @Override
    public Tag<V> getTagOrCreate(Key key, Function<Key, Tag<V>> factory) {
        Tag<V> result = this.tags.get(key);
        if (result == null) {
            this.checkLock();
            result = this.tags.computeIfAbsent(key, factory);
        }
        return result;
    }

    @Override
    public boolean registerTag(Tag<V> tag) {
        this.checkLock();
        return this.tags.putIfAbsent(tag.key(), tag) == null;
    }

    @Override
    public Stream<Tag<V>> tags() {
        return this.tags.values().stream();
    }

    public static class SimpleMutableRegistry<K, V>
    extends SimpleRegistry<K, V>
    implements MutableRegistry<K, V> {
        protected SimpleMutableRegistry(DataKey<V> key, Function<V, K> inverseMapper, Function<String, K> keyMapper) {
            super(key, inverseMapper, keyMapper);
        }

        @Override
        public boolean invalidateKey(K key) {
            this.checkLock();
            Object value = this.registryMap.remove(key);
            if (value == null) {
                return false;
            }
            if (!this.tags.isEmpty()) {
                this.tags.entrySet().removeIf(e -> ((Tag)e.getValue()).containsValue(value));
            }
            return true;
        }

        @Override
        public boolean invalidateValue(V value) {
            return this.invalidateKey(this.inverseMapper.apply(value));
        }

        @Override
        public boolean clear() {
            this.checkLock();
            this.tags.clear();
            this.registryMap.clear();
            return true;
        }
    }
}

