/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.registry;

import java.util.Objects;
import java.util.function.Function;
import me.moros.bending.api.registry.DefaultedRegistry;
import me.moros.bending.api.registry.MutableRegistry;
import me.moros.bending.api.registry.Registry;
import me.moros.bending.api.registry.SimpleRegistry;
import me.moros.bending.api.util.data.DataKey;
import org.jspecify.annotations.Nullable;

public final class RegistryBuilder<K, V> {
    private final DataKey<V> key;
    private final Function<V, K> inverseMapper;
    private final Function<String, @Nullable K> keyMapper;

    private RegistryBuilder(DataKey<V> key, Function<V, K> inverseMapper, Function<String, @Nullable K> keyMapper) {
        this.key = key;
        this.inverseMapper = inverseMapper;
        this.keyMapper = keyMapper;
    }

    public Registry<K, V> build() {
        return new SimpleRegistry<K, V>(this.key, this.inverseMapper, this.keyMapper);
    }

    public MutableRegistry<K, V> buildMutable() {
        return new SimpleRegistry.SimpleMutableRegistry<K, V>(this.key, this.inverseMapper, this.keyMapper);
    }

    public DefaultedRegistry<K, V> buildDefaulted(Function<K, V> factory) {
        Objects.requireNonNull(factory);
        return new DefaultedRegistry<K, V>(this.key, this.inverseMapper, this.keyMapper, factory);
    }

    public static final class IntermediaryRegistryBuilder2<K, V> {
        private final DataKey<V> key;
        private final Function<V, K> inverseMapper;

        IntermediaryRegistryBuilder2(DataKey<V> key, Function<V, K> inverseMapper) {
            this.key = key;
            this.inverseMapper = inverseMapper;
        }

        public RegistryBuilder<K, V> keyMapper(Function<String, @Nullable K> keyMapper) {
            Objects.requireNonNull(keyMapper);
            return new RegistryBuilder<K, V>(this.key, this.inverseMapper, keyMapper);
        }
    }

    public static final class IntermediaryRegistryBuilder<V> {
        private final DataKey<V> key;

        IntermediaryRegistryBuilder(DataKey<V> key) {
            this.key = key;
        }

        public <K> IntermediaryRegistryBuilder2<K, V> inverseMapper(Function<V, K> inverseMapper) {
            Objects.requireNonNull(inverseMapper);
            return new IntermediaryRegistryBuilder2<K, V>(this.key, inverseMapper);
        }
    }
}

