/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.registry;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import me.moros.bending.api.registry.Container;
import me.moros.bending.api.registry.DefaultedRegistry;
import me.moros.bending.api.registry.RegistryBuilder;
import me.moros.bending.api.registry.TagHolder;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.data.DataKey;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import org.jspecify.annotations.Nullable;

public interface Registry<K, V>
extends Container<V>,
TagHolder<V> {
    public DataKey<V> key();

    public boolean containsKey(K var1);

    public @Nullable V get(K var1);

    default public V getOrThrow(K key) {
        return Objects.requireNonNull(this.get(key), "No mapping found for " + String.valueOf(key));
    }

    default public Optional<V> getIfExists(K key) {
        return Optional.ofNullable(this.get(key));
    }

    public @Nullable V fromString(String var1);

    public boolean register(V var1);

    default public int register(Iterable<V> values) {
        int counter = 0;
        if (!this.isLocked()) {
            for (V value : values) {
                if (!this.register(value)) continue;
                ++counter;
            }
        }
        return counter;
    }

    public void lock();

    public boolean isLocked();

    public Stream<K> streamKeys();

    public Set<K> keys();

    public static <V> RegistryBuilder.IntermediaryRegistryBuilder<V> builder(DataKey<V> key) {
        Objects.requireNonNull(key);
        return new RegistryBuilder.IntermediaryRegistryBuilder<V>(key);
    }

    public static <V extends Keyed> RegistryBuilder<Key, V> simpleBuilder(DataKey<V> key) {
        return Registry.builder(key).inverseMapper(Keyed::key).keyMapper(KeyUtil.stringToKey(key.namespace()));
    }

    public static <V extends Keyed> RegistryBuilder<Key, V> vanillaBuilder(DataKey<V> key) {
        return Registry.builder(key).inverseMapper(Keyed::key).keyMapper(KeyUtil.VANILLA_KEY_MAPPER);
    }

    public static <V extends Keyed> Registry<Key, V> vanilla(String name, Class<V> type) {
        return Registry.vanillaBuilder(DataKey.wrap(KeyUtil.vanilla(name), type)).build();
    }

    public static <V extends Keyed> DefaultedRegistry<Key, V> vanillaDefaulted(String name, Class<V> type, Function<Key, V> factory) {
        return Registry.vanillaBuilder(DataKey.wrap(KeyUtil.vanilla(name), type)).buildDefaulted(factory);
    }
}

