/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.collision.CollisionPair;
import me.moros.bending.api.locale.Translation;
import me.moros.bending.api.protection.Protection;
import me.moros.bending.api.registry.Registry;
import me.moros.bending.api.registry.UserRegistry;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.data.DataKey;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import org.jspecify.annotations.Nullable;

public final class Registries {
    private static final Map<DataKey<?>, Registry<Key, ? extends Keyed>> REGISTRIES_BY_KEY = new HashMap();
    public static final Registry<Key, AbilityDescription> ABILITIES = Registries.create("ability", AbilityDescription.class);
    public static final Registry<Key, AbilityDescription.Sequence> SEQUENCES = Registries.create("sequence", AbilityDescription.Sequence.class);
    public static final Registry<Key, CollisionPair> COLLISIONS = Registries.create("collision", CollisionPair.class);
    public static final Registry<Key, Protection> PROTECTIONS = Registries.create("protection", Protection.class);
    public static final Registry<Key, Translation> TRANSLATIONS = Registries.create("translation", Translation.class);
    public static final UserRegistry BENDERS = new UserRegistry();

    private Registries() {
    }

    public static Stream<DataKey<?>> keys() {
        return REGISTRIES_BY_KEY.keySet().stream();
    }

    public static <T> @Nullable Registry<Key, T> get(DataKey<T> type) {
        return REGISTRIES_BY_KEY.get(type);
    }

    public static <T> Registry<Key, T> getOrThrow(DataKey<T> type) {
        return Objects.requireNonNull(Registries.get(type));
    }

    private static <T extends Keyed> Registry<Key, T> create(String name, Class<T> clazz) {
        Registry<Key, T> registry = Registry.simpleBuilder(KeyUtil.data("registry." + name, clazz)).build();
        REGISTRIES_BY_KEY.put((DataKey<?>)registry.key(), (Registry<Key, Keyed>)registry);
        return registry;
    }
}

