/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.world;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.moros.bending.api.collision.raytrace.BlockRayTrace;
import me.moros.bending.api.collision.raytrace.CompositeRayTrace;
import me.moros.bending.api.collision.raytrace.Context;
import me.moros.bending.api.collision.raytrace.RayTrace;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.platform.particle.ParticleContext;
import me.moros.bending.api.platform.world.BlockGetter;
import me.moros.bending.api.platform.world.BlockSetter;
import me.moros.bending.api.platform.world.EntityAccessor;
import me.moros.math.Position;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.key.Keyed;

public interface World
extends Keyed,
ForwardingAudience,
BlockGetter,
BlockSetter,
EntityAccessor {
    @Override
    default public Block blockAt(int x, int y, int z) {
        return new Block(this, x, y, z);
    }

    public String name();

    public int minHeight();

    public int maxHeight();

    default public int height() {
        return this.maxHeight() - this.minHeight();
    }

    public <T> void spawnParticle(ParticleContext<T> var1);

    public BlockRayTrace rayTraceBlocks(Context var1);

    public CompositeRayTrace rayTraceEntities(Context var1, double var2);

    default public CompositeRayTrace rayTrace(Context context) {
        double distSq;
        BlockRayTrace blockResult = this.rayTraceBlocks(context);
        double blockHitDistance = blockResult.hit() ? blockResult.position().distance(context.origin()) : context.range();
        CompositeRayTrace entityResult = this.rayTraceEntities(context, blockHitDistance);
        Block block = blockResult.block();
        if (block == null) {
            return entityResult;
        }
        if (entityResult.hit() && (distSq = context.origin().distanceSq(entityResult.position())) < blockHitDistance * blockHitDistance) {
            return entityResult;
        }
        return RayTrace.hit(blockResult.position(), block);
    }

    @Override
    default public boolean setBlockStateFast(int x, int y, int z, BlockState state) {
        return Platform.instance().nativeAdapter().setBlockFast(new Block(this, x, y, z), state);
    }

    @Override
    default public Optional<Block> findTop(Position origin, int height, Predicate<Block> predicate) {
        Block block = new Block(this, origin);
        for (int i = 1; i <= height; ++i) {
            Block check = block.offset(Direction.UP, i);
            if (predicate.test(check)) continue;
            return Optional.of(check.offset(Direction.DOWN));
        }
        return Optional.empty();
    }

    @Override
    default public Optional<Block> findBottom(Position origin, int height, Predicate<Block> predicate) {
        Block block = new Block(this, origin);
        for (int i = 1; i <= height; ++i) {
            Block check = block.offset(Direction.DOWN, i);
            if (predicate.test(check)) continue;
            return Optional.of(check.offset(Direction.UP));
        }
        return Optional.empty();
    }

    public boolean isDay();

    public boolean isNight();

    public Entity createEntity(Position var1, EntityType var2);

    public boolean addEntity(Entity var1);

    default public Optional<Entity> spawnEntity(Position pos, EntityType type, Consumer<Entity> consumer) {
        Entity entity = this.createEntity(pos, type);
        consumer.accept(entity);
        return this.addEntity(entity) ? Optional.of(entity) : Optional.empty();
    }

    default public Entity dropItem(Position pos, ItemSnapshot item) {
        return this.dropItem(pos, item, true);
    }

    public Entity dropItem(Position var1, ItemSnapshot var2, boolean var3);

    public Entity createFallingBlock(Position var1, BlockState var2, boolean var3);

    default public int lightLevel(Position position) {
        return this.lightLevel(position.blockX(), position.blockY(), position.blockZ());
    }

    public int lightLevel(int var1, int var2, int var3);

    default public int blockLightLevel(Position position) {
        return this.blockLightLevel(position.blockX(), position.blockY(), position.blockZ());
    }

    public int blockLightLevel(int var1, int var2, int var3);

    default public int skyLightLevel(Position position) {
        return this.skyLightLevel(position.blockX(), position.blockY(), position.blockZ());
    }

    public int skyLightLevel(int var1, int var2, int var3);

    public Dimension dimension();

    default public CompletableFuture<?> loadChunkAsync(Position position) {
        return this.loadChunkAsync(position.blockX() >> 4, position.blockZ() >> 4);
    }

    public CompletableFuture<?> loadChunkAsync(int var1, int var2);

    public int viewDistance();

    public static enum Dimension {
        OVERWORLD,
        NETHER,
        END,
        CUSTOM;

    }
}

