/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.sound;

import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.sound.SoundEffectImpl;
import me.moros.bending.api.platform.sound.Sounds;
import me.moros.bending.api.platform.world.World;
import me.moros.math.Position;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.sound.Sound;

public interface SoundEffect
extends Keyed {
    public static final SoundEffect AIR = Sounds.ENTITY_BREEZE_SLIDE.asEffect(1.0f, 0.8f);
    public static final SoundEffect AIR_FAST = AIR.with(1.0f, 1.4f);
    public static final SoundEffect WATER = Sounds.BLOCK_WATER_AMBIENT.asEffect();
    public static final SoundEffect ICE = Sounds.ITEM_FLINTANDSTEEL_USE.asEffect();
    public static final SoundEffect PLANT = Sounds.BLOCK_GRASS_STEP.asEffect();
    public static final SoundEffect EARTH = Sounds.ENTITY_GHAST_SHOOT.asEffect();
    public static final SoundEffect SAND = Sounds.BLOCK_SAND_BREAK.asEffect();
    public static final SoundEffect METAL = Sounds.ENTITY_IRON_GOLEM_HURT.asEffect(1.0f, 1.25f);
    public static final SoundEffect LAVA = Sounds.BLOCK_LAVA_AMBIENT.asEffect();
    public static final SoundEffect FIRE = Sounds.BLOCK_FIRE_AMBIENT.asEffect();
    public static final SoundEffect COMBUSTION = Sounds.ENTITY_FIREWORK_ROCKET_BLAST.asEffect(1.0f, 0.0f);
    public static final SoundEffect LIGHTNING = Sounds.ENTITY_CREEPER_HURT.asEffect(1.0f, 0.0f);
    public static final SoundEffect LIGHTNING_CHARGING = Sounds.BLOCK_BEEHIVE_WORK.asEffect(2.0f, 0.5f);
    public static final SoundEffect FIRE_EXTINGUISH = Sounds.BLOCK_FIRE_EXTINGUISH.asEffect(0.5f, 1.0f);
    public static final SoundEffect LAVA_EXTINGUISH = Sounds.BLOCK_LAVA_EXTINGUISH.asEffect();
    public static final SoundEffect EXPLOSION = Sounds.ENTITY_GENERIC_EXPLODE.asEffect(2.0f, 0.0f);

    public Sound sound();

    default public Key name() {
        return this.sound().name();
    }

    default public Sound.Source source() {
        return this.sound().source();
    }

    default public float volume() {
        return this.sound().volume();
    }

    default public float pitch() {
        return this.sound().pitch();
    }

    default public void play(Block block) {
        block.world().playSound(this.sound(), block.x() + 0.5, block.y() + 0.5, block.z() + 0.5);
    }

    default public void play(World world, Position center) {
        world.playSound(this.sound(), center.x(), center.y(), center.z());
    }

    default public SoundEffect with(float volume, float pitch) {
        return new SoundEffectImpl(this.name(), this.source(), volume, pitch);
    }
}

