/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.property;

import me.moros.bending.api.platform.property.BooleanProperty;
import me.moros.bending.api.platform.property.DoubleProperty;
import me.moros.bending.api.platform.property.FloatProperty;
import me.moros.bending.api.platform.property.IntegerProperty;
import me.moros.bending.api.platform.property.SimpleProperty;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.data.DataKeyed;
import org.jspecify.annotations.Nullable;

public sealed interface Property<T>
extends DataKeyed<T>
permits SimpleProperty {
    default public boolean isValidValue(@Nullable T value) {
        return value != null;
    }

    public static BooleanProperty boolProp(String name) {
        return new BooleanProperty(name);
    }

    public static DoubleProperty doubleProp(String name) {
        return Property.doubleProp(name, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static DoubleProperty doubleProp(String name, double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("Invalid range. Min: " + min + ", Max: " + max);
        }
        return new DoubleProperty(name, min, max);
    }

    public static FloatProperty floatProp(String name) {
        return Property.floatProp(name, -3.4028235E38f, Float.MAX_VALUE);
    }

    public static FloatProperty floatProp(String name, float min, float max) {
        if (min > max) {
            throw new IllegalArgumentException("Invalid range. Min: " + min + ", Max: " + max);
        }
        return new FloatProperty(name, min, max);
    }

    public static IntegerProperty intProp(String name) {
        return Property.intProp(name, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static IntegerProperty intProp(String name, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("Invalid range. Min: " + min + ", Max: " + max);
        }
        return new IntegerProperty(name, min, max);
    }

    public static <T> Property<T> prop(String name, Class<T> type) {
        return new SimpleProperty<T>(DataKey.wrap(KeyUtil.simple(name), type));
    }
}

