/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.potion;

import me.moros.bending.api.platform.potion.Potion;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.platform.potion.PotionImpl;

public class PotionBuilder {
    private final PotionEffect effect;
    private int duration = 100;
    private int amplifier = 0;
    private boolean ambient = true;
    private boolean particles = false;
    private boolean icon = false;

    PotionBuilder(PotionEffect effect) {
        this.effect = effect;
    }

    public PotionBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    public PotionBuilder amplifier(int amplifier) {
        this.amplifier = amplifier;
        return this;
    }

    public PotionBuilder ambient(boolean ambient) {
        this.ambient = ambient;
        return this;
    }

    public PotionBuilder particles(boolean particles) {
        this.particles = particles;
        return this;
    }

    public PotionBuilder icon(boolean icon) {
        this.icon = icon;
        return this;
    }

    public Potion build() {
        return new PotionImpl(this.effect, this.duration, this.amplifier, this.ambient, this.particles, this.icon);
    }
}

