/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.entity.display;

import java.util.Objects;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.entity.display.Billboard;
import me.moros.bending.api.platform.entity.display.BlockDisplay;
import me.moros.bending.api.platform.entity.display.BlockDisplayBuilder;
import me.moros.bending.api.platform.entity.display.DisplayBuilder;
import me.moros.bending.api.platform.entity.display.ItemDisplay;
import me.moros.bending.api.platform.entity.display.ItemDisplayBuilder;
import me.moros.bending.api.platform.entity.display.TextDisplay;
import me.moros.bending.api.platform.entity.display.TextDisplayBuilder;
import me.moros.bending.api.platform.entity.display.Transformation;
import me.moros.bending.api.platform.item.Item;
import net.kyori.adventure.text.Component;

public sealed interface Display<V>
permits BlockDisplay, ItemDisplay, TextDisplay {
    public V data();

    public float width();

    public float height();

    public float viewRange();

    public float shadowRadius();

    public float shadowStrength();

    public int interpolationDelay();

    public int transformationInterpolationDuration();

    public int positionInterpolationDuration();

    public int brightness();

    public int glowColor();

    public Billboard billboard();

    public Transformation transformation();

    public DisplayBuilder<V, ?> toBuilder();

    public static BlockDisplayBuilder block(BlockState data) {
        Objects.requireNonNull(data);
        return (BlockDisplayBuilder)new BlockDisplayBuilder().data(data);
    }

    public static ItemDisplayBuilder item(Item data) {
        Objects.requireNonNull(data);
        return (ItemDisplayBuilder)new ItemDisplayBuilder().data(data);
    }

    public static TextDisplayBuilder text(Component data) {
        Objects.requireNonNull(data);
        return (TextDisplayBuilder)new TextDisplayBuilder().data(data);
    }
}

