/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.entity.display;

import java.util.Objects;
import java.util.function.Function;
import me.moros.bending.api.platform.entity.display.Billboard;
import me.moros.bending.api.platform.entity.display.BlockDisplayBuilder;
import me.moros.bending.api.platform.entity.display.Display;
import me.moros.bending.api.platform.entity.display.DisplayBuilder;
import me.moros.bending.api.platform.entity.display.ItemDisplayBuilder;
import me.moros.bending.api.platform.entity.display.TextDisplayBuilder;
import me.moros.bending.api.platform.entity.display.Transformation;
import me.moros.math.Vector3d;
import net.kyori.adventure.util.RGBLike;

sealed class AbstractDisplayBuilder<V, T extends AbstractDisplayBuilder<V, T>>
implements DisplayBuilder<V, T>
permits BlockDisplayBuilder, ItemDisplayBuilder, TextDisplayBuilder {
    private final Function<? super T, Display<? super V>> factory;
    private V data;
    private float width = 1.0f;
    private float height = 1.0f;
    private float viewRange = 1.0f;
    private float shadowRadius = 0.0f;
    private float shadowStrength = 1.0f;
    private int interpolationDelay = 0;
    private int transformationInterpolationDuration = 0;
    private int positionInterpolationDuration = 0;
    private int brightness = -1;
    private int glowColor = -1;
    private Billboard billboard = Billboard.FIXED;
    private Transformation transformation = new Transformation(Vector3d.ZERO, Vector3d.ONE);

    AbstractDisplayBuilder(Function<T, Display<? super V>> factory) {
        this.factory = factory;
    }

    AbstractDisplayBuilder(Function<T, Display<? super V>> factory, Display<V> display) {
        this(factory);
        this.data((Object)display.data());
        this.width(display.width());
        this.height(display.height());
        this.viewRange(display.viewRange());
        this.shadowRadius(display.shadowRadius());
        this.shadowStrength(display.shadowStrength());
        this.interpolationDelay(display.interpolationDelay());
        this.transformationInterpolationDuration(display.transformationInterpolationDuration());
        this.positionInterpolationDuration(display.positionInterpolationDuration());
        this.brightness(display.brightness());
        this.glowColor(display.glowColor());
        this.billboard(display.billboard());
        this.transformation(display.transformation());
    }

    @Override
    public V data() {
        return this.data;
    }

    @Override
    public T data(V data) {
        this.data = Objects.requireNonNull(data);
        return (T)this;
    }

    @Override
    public float width() {
        return this.width;
    }

    @Override
    public T width(float width) {
        this.width = width;
        return (T)this;
    }

    @Override
    public float height() {
        return this.height;
    }

    @Override
    public T height(float height) {
        this.height = height;
        return (T)this;
    }

    @Override
    public float viewRange() {
        return this.viewRange;
    }

    @Override
    public T viewRange(float viewRange) {
        this.viewRange = viewRange;
        return (T)this;
    }

    @Override
    public float shadowRadius() {
        return this.shadowRadius;
    }

    @Override
    public T shadowRadius(float shadowRadius) {
        this.shadowRadius = shadowRadius;
        return (T)this;
    }

    @Override
    public float shadowStrength() {
        return this.shadowStrength;
    }

    @Override
    public T shadowStrength(float shadowStrength) {
        this.shadowStrength = shadowStrength;
        return (T)this;
    }

    @Override
    public int interpolationDelay() {
        return this.interpolationDelay;
    }

    @Override
    public T interpolationDelay(int interpolationDelay) {
        this.interpolationDelay = interpolationDelay;
        return (T)this;
    }

    @Override
    public int transformationInterpolationDuration() {
        return this.transformationInterpolationDuration;
    }

    @Override
    public T transformationInterpolationDuration(int transformationInterpolationDuration) {
        this.transformationInterpolationDuration = transformationInterpolationDuration;
        return (T)this;
    }

    @Override
    public int positionInterpolationDuration() {
        return this.positionInterpolationDuration;
    }

    @Override
    public T positionInterpolationDuration(int positionInterpolationDuration) {
        this.positionInterpolationDuration = positionInterpolationDuration;
        return (T)this;
    }

    @Override
    public int brightness() {
        return this.brightness;
    }

    @Override
    public T brightness(int brightness) {
        this.brightness = brightness;
        return (T)this;
    }

    @Override
    public int glowColor() {
        return this.glowColor;
    }

    @Override
    public T glowColor(RGBLike color) {
        return (T)this.glowColor(AbstractDisplayBuilder.rgbToInt(color));
    }

    @Override
    public T glowColor(int argb) {
        this.glowColor = argb;
        return (T)this;
    }

    @Override
    public Billboard billboard() {
        return this.billboard;
    }

    @Override
    public T billboard(Billboard billboard) {
        this.billboard = Objects.requireNonNull(billboard);
        return (T)this;
    }

    @Override
    public Transformation transformation() {
        return this.transformation;
    }

    @Override
    public T transformation(Transformation transformation) {
        this.transformation = Objects.requireNonNull(transformation);
        return (T)this;
    }

    @Override
    public Display<? super V> build() {
        return this.factory.apply(this);
    }

    protected static int rgbToInt(RGBLike color) {
        return 0xFF000000 | color.red() << 16 | color.green() << 8 | color.blue();
    }
}

