/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.entity;

import java.util.Collection;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.collision.raytrace.Context;
import me.moros.bending.api.collision.raytrace.ContextBuilder;
import me.moros.bending.api.event.EventBus;
import me.moros.bending.api.event.VelocityEvent;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.item.Inventory;
import me.moros.bending.api.platform.potion.Potion;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import net.kyori.adventure.util.TriState;
import org.jspecify.annotations.Nullable;

public interface LivingEntity
extends Entity {
    public double eyeHeight();

    default public Block eyeBlock() {
        return this.world().blockAt(this.eyeLocation());
    }

    default public Vector3d eyeLocation() {
        return this.location().add(0.0, this.eyeHeight(), 0.0);
    }

    @Override
    default public boolean applyVelocity(Ability ability, Vector3d velocity) {
        EventBus eventBus = ability.user().game().eventBus();
        VelocityEvent event = eventBus.postVelocityEvent(ability.user(), this, ability.description(), velocity);
        if (!event.cancelled()) {
            this.velocity(velocity);
            return true;
        }
        return false;
    }

    default public Ray ray() {
        return Ray.of(this.eyeLocation(), this.direction());
    }

    default public Ray ray(double range) {
        return Ray.of(this.eyeLocation(), (Vector3d)this.direction().multiply(range));
    }

    default public boolean sneaking() {
        return this.propertyValue(EntityProperties.SNEAKING);
    }

    default public void sneaking(boolean sneaking) {
        this.setProperty(EntityProperties.SNEAKING, sneaking);
    }

    public @Nullable Inventory inventory();

    default public ContextBuilder rayTrace(double range) {
        return Context.builder(this.eyeLocation(), this.direction()).range(range).filterForUser(this);
    }

    default public ContextBuilder rayTrace(Vector3d origin, Vector3d dir) {
        return Context.builder(origin, dir).filterForUser(this);
    }

    default public Vector3d mainHandSide() {
        Vector3d dir = (Vector3d)this.direction().multiply(0.4);
        return switch (TriState.byBoolean((Boolean)this.property(EntityProperties.RIGHT_HAND))) {
            default -> throw new MatchException(null, null);
            case TriState.TRUE -> this.handSide(true);
            case TriState.FALSE -> this.handSide(false);
            case TriState.NOT_SET -> (Vector3d)this.eyeLocation().add(dir);
        };
    }

    default public Vector3d handSide(boolean right) {
        double y = this.sneaking() ? 1.2 : 1.575;
        Vector3d offset = ((Vector3d)this.direction().multiply(0.4)).add(0.0, y, 0.0);
        return right ? (Vector3d)this.rightSide().add(offset) : (Vector3d)this.leftSide().add(offset);
    }

    default public Vector3d rightSide() {
        double angle = Math.toRadians(this.yaw());
        return (Vector3d)this.location().subtract((Position)Vector3d.of(Math.cos(angle), 0.0, Math.sin(angle)).normalize().multiply(0.3));
    }

    default public Vector3d leftSide() {
        double angle = Math.toRadians(this.yaw());
        return (Vector3d)this.location().add((Position)Vector3d.of(Math.cos(angle), 0.0, Math.sin(angle)).normalize().multiply(0.3));
    }

    public boolean addPotion(Potion var1);

    default public boolean addPotions(Iterable<Potion> potions) {
        boolean result = true;
        for (Potion potion : potions) {
            result &= this.addPotion(potion);
        }
        return result;
    }

    public boolean hasPotion(PotionEffect var1);

    public @Nullable Potion potion(PotionEffect var1);

    public void removePotion(PotionEffect var1);

    public Collection<Potion> activePotions();

    @Override
    default public boolean isProjectile() {
        return false;
    }

    public Entity shootArrow(Position var1, Vector3d var2, double var3);
}

