/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.entity;

import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Damageable;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.property.BooleanProperty;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.util.data.DataHolder;
import me.moros.bending.api.util.data.DataKeyed;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.TriState;
import org.jspecify.annotations.Nullable;

public interface Entity
extends ForwardingAudience.Single,
Damageable,
DataHolder {
    default public int id() {
        return this.propertyValue(EntityProperties.ENTITY_ID);
    }

    default public UUID uuid() {
        return this.propertyValue(EntityProperties.UUID);
    }

    default public EntityType type() {
        return this.propertyValue(EntityProperties.ENTITY_TYPE);
    }

    default public Component name() {
        return this.propertyValue(EntityProperties.NAME);
    }

    default public World world() {
        return this.propertyValue(EntityProperties.WORLD);
    }

    default public Key worldKey() {
        return this.world().key();
    }

    default public double width() {
        return this.propertyValue(EntityProperties.WIDTH);
    }

    default public double height() {
        return this.propertyValue(EntityProperties.HEIGHT);
    }

    default public float yaw() {
        return this.propertyValue(EntityProperties.YAW).floatValue();
    }

    default public float pitch() {
        return this.propertyValue(EntityProperties.PITCH).floatValue();
    }

    default public Vector3d center() {
        return this.location().add(0.0, this.height() / 2.0, 0.0);
    }

    default public Block block() {
        return this.world().blockAt(this.location());
    }

    default public Vector3d location() {
        return this.propertyValue(EntityProperties.POSITION);
    }

    default public Vector3d direction() {
        double xRadians = Math.toRadians(this.propertyValue(EntityProperties.YAW).floatValue());
        double yRadians = Math.toRadians(this.propertyValue(EntityProperties.PITCH).floatValue());
        double a = Math.cos(yRadians);
        return Vector3d.of(-a * Math.sin(xRadians), -Math.sin(yRadians), a * Math.cos(xRadians));
    }

    default public Vector3d velocity() {
        return this.propertyValue(EntityProperties.VELOCITY);
    }

    default public void velocity(Vector3d velocity) {
        this.setProperty(EntityProperties.VELOCITY, velocity);
    }

    default public boolean applyVelocity(Ability ability, Vector3d velocity) {
        this.velocity(velocity);
        return true;
    }

    public boolean valid();

    default public AABB bounds() {
        return this.dimensions(this.location());
    }

    default public AABB dimensions(Position pos) {
        double hw = 0.5 * this.width();
        Vector3d min = Vector3d.of(pos.x() - hw, pos.y(), pos.z() - hw);
        Vector3d max = Vector3d.of(pos.x() + hw, pos.y() + this.height(), pos.z() + hw);
        return AABB.of(min, max);
    }

    public boolean isOnGround();

    default public double distanceAboveGround() {
        return this.distanceAboveGround(this.world().height());
    }

    default public double distanceAboveGround(double maxHeight) {
        Block check;
        int minHeight = this.world().minHeight();
        double bottomY = this.location().y();
        AABB entityBounds = this.bounds().grow(Vector3d.of(0.0, maxHeight, 0.0));
        Block origin = this.block();
        int i = 0;
        while ((double)i < maxHeight && (check = origin.offset(Direction.DOWN, i)).blockY() > minHeight) {
            AABB checkBounds;
            AABB aABB = checkBounds = check.type().isLiquid() ? AABB.BLOCK_BOUNDS.at(check) : check.bounds();
            if (checkBounds.intersects(entityBounds)) {
                return Math.max(0.0, bottomY - checkBounds.max().y());
            }
            ++i;
        }
        return maxHeight;
    }

    default public boolean inWater() {
        return this.propertyValue(EntityProperties.IN_WATER);
    }

    default public boolean underWater() {
        return this.inWater() && Platform.instance().nativeAdapter().eyeInWater(this);
    }

    default public boolean inLava() {
        return this.propertyValue(EntityProperties.IN_LAVA);
    }

    default public boolean underLava() {
        return this.inLava() && Platform.instance().nativeAdapter().eyeInLava(this);
    }

    public void remove();

    public boolean isProjectile();

    default public boolean teleport(Position position) {
        return this.setProperty(EntityProperties.POSITION, position.toVector3d());
    }

    default public TriState checkProperty(BooleanProperty property) {
        return TriState.byBoolean((Boolean)this.property(property));
    }

    default public void setProperty(BooleanProperty property, TriState value) {
        if (value != TriState.NOT_SET) {
            this.setProperty(property, value == TriState.TRUE);
        }
    }

    public <V> @Nullable V property(DataKeyed<V> var1);

    default public <V> V propertyValue(DataKeyed<V> dataKeyed) {
        return Objects.requireNonNull(this.property(dataKeyed));
    }

    public <V> boolean setProperty(DataKeyed<V> var1, V var2);

    public <V> boolean editProperty(DataKeyed<V> var1, UnaryOperator<V> var2);
}

