/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.block;

import java.util.Iterator;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.moros.bending.api.platform.block.BlockTag;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.registry.Container;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.functional.Suppliers;
import net.kyori.adventure.key.Key;

record TagImpl(Key key, Supplier<Container<BlockType>> supplier) implements BlockTag
{
    private static final Container<BlockType> EMPTY = Container.create(KeyUtil.simple("empty"), Set.of());

    static BlockTag get(String key) {
        return TagImpl.reference(KeyUtil.vanilla(key));
    }

    static BlockTag reference(Key key) {
        return new TagImpl(key, Suppliers.lazy(() -> BlockType.registry().getTag(key)));
    }

    static BlockTag fromContainer(Container<BlockType> container) {
        return new TagImpl(container.key(), Suppliers.cached(container));
    }

    Container<BlockType> container() {
        Container<BlockType> container = this.supplier().get();
        return container == null ? EMPTY : container;
    }

    @Override
    public boolean containsValue(BlockType type) {
        return this.container().containsValue(type);
    }

    @Override
    public int size() {
        return this.container().size();
    }

    @Override
    public Stream<BlockType> stream() {
        return this.container().stream();
    }

    @Override
    public Iterator<BlockType> iterator() {
        return this.container().iterator();
    }
}

