/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.block;

import java.util.Optional;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.sound.SoundGroup;
import me.moros.bending.api.registry.DefaultedRegistry;
import me.moros.bending.api.registry.Registry;
import me.moros.bending.api.util.KeyUtil;
import net.kyori.adventure.key.Key;

record BlockTypeImpl(Key key) implements BlockType
{
    static final DefaultedRegistry<Key, BlockType> REGISTRY = Registry.vanillaDefaulted("blocks", BlockType.class, BlockTypeImpl::new);
    static final Registry<Key, BlockProperties> PROPERTY_REGISTRY = Registry.vanilla("block.properties", BlockProperties.class);
    static final Registry<Key, BlockState> STATE_REGISTRY = Registry.vanilla("block.state", BlockState.class);
    static final Registry<Key, Item> ITEM_REGISTRY = Registry.vanilla("block.item", Item.class);

    static BlockType get(String key) {
        return REGISTRY.get(KeyUtil.vanilla(key));
    }

    BlockProperties fromVanilla() {
        return PROPERTY_REGISTRY.getOrThrow(this.key());
    }

    @Override
    public boolean isAir() {
        return this.fromVanilla().isAir();
    }

    @Override
    public boolean isSolid() {
        return this.fromVanilla().isSolid();
    }

    @Override
    public boolean isLiquid() {
        return this.fromVanilla().isLiquid();
    }

    @Override
    public boolean isFlammable() {
        return this.fromVanilla().isFlammable();
    }

    @Override
    public boolean hasGravity() {
        return this.fromVanilla().hasGravity();
    }

    @Override
    public boolean isCollidable() {
        return this.fromVanilla().isCollidable();
    }

    @Override
    public double hardness() {
        return this.fromVanilla().hardness();
    }

    public String translationKey() {
        return this.fromVanilla().translationKey();
    }

    @Override
    public SoundGroup soundGroup() {
        return this.fromVanilla().soundGroup();
    }

    @Override
    public BlockState defaultState() {
        return STATE_REGISTRY.getOrThrow(this.key());
    }

    @Override
    public Optional<Item> asItem() {
        return Optional.ofNullable(ITEM_REGISTRY.get(this.key()));
    }
}

