/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.locale;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;

public final class Translation
implements Keyed,
Iterable<Map.Entry<String, MessageFormat>> {
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private final Key key;
    private final Locale locale;
    private final Map<String, MessageFormat> formats;
    private final int hashcode;

    private Translation(Key key, Locale locale, Map<String, MessageFormat> formats) {
        this.key = key;
        this.locale = locale;
        this.formats = Map.copyOf(formats);
        this.hashcode = Objects.hash(this.key, this.formats);
    }

    public Locale locale() {
        return this.locale;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Translation) {
            Translation other = (Translation)obj;
            return this.key.equals((Object)other.key) && this.formats.equals(other.formats);
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public Key key() {
        return this.key;
    }

    @Override
    public Iterator<Map.Entry<String, MessageFormat>> iterator() {
        return this.formats.entrySet().iterator();
    }

    public static Translation fromBundle(Key key, ResourceBundle bundle) {
        return Translation.fromBundle(key, DEFAULT_LOCALE, bundle);
    }

    public static Translation fromBundle(Key key, Locale locale, ResourceBundle bundle) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(bundle);
        HashMap<String, MessageFormat> formats = new HashMap<String, MessageFormat>();
        for (String bundleKey : bundle.keySet()) {
            formats.put(bundleKey, new MessageFormat(bundle.getString(bundleKey), locale));
        }
        if (formats.isEmpty()) {
            throw new IllegalArgumentException("No translations found.");
        }
        return new Translation(key, locale, formats);
    }

    public static Translation create(Key key, Map<String, String> translations) {
        return Translation.create(key, DEFAULT_LOCALE, translations);
    }

    public static Translation create(Key key, Locale locale, Map<String, String> translations) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(locale);
        Objects.requireNonNull(translations);
        HashMap<String, MessageFormat> formats = new HashMap<String, MessageFormat>();
        for (Map.Entry<String, String> entry : translations.entrySet()) {
            formats.put(entry.getKey(), new MessageFormat(entry.getValue(), locale));
        }
        if (formats.isEmpty()) {
            throw new IllegalArgumentException("No translations found.");
        }
        return new Translation(key, locale, formats);
    }
}

