/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.config.attribute;

import java.util.Objects;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.AttributeModifier;
import me.moros.bending.api.config.attribute.AttributeModifierImpl;
import me.moros.bending.api.config.attribute.Modifier;
import me.moros.bending.api.config.attribute.ModifyPolicy;

record ModifierImpl(double additive, double summedMultiplicative, double multiplicative) implements Modifier
{
    @Override
    public Modifier merge(Modifier other) {
        ModifierImpl otherModifier = (ModifierImpl)other;
        double additive = this.additive + otherModifier.additive;
        double summedMultiplicative = this.summedMultiplicative + otherModifier.summedMultiplicative;
        double multiplicative = this.multiplicative * otherModifier.multiplicative;
        return new ModifierImpl(additive, summedMultiplicative, multiplicative);
    }

    @Override
    public AttributeModifier asAttributeModifier(ModifyPolicy policy, Attribute attribute) {
        Objects.requireNonNull(policy);
        Objects.requireNonNull(attribute);
        return new AttributeModifierImpl(policy, attribute, this);
    }

    @Override
    public double applyAsDouble(double value) {
        return (value + this.additive) * (1.0 + this.summedMultiplicative) * this.multiplicative;
    }
}

