/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.collision.geometry;

import java.util.ArrayList;
import java.util.Collection;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.user.User;
import me.moros.math.Vector3d;

public final class RayUtil {
    private static final double ANGLE_STEP = Math.toRadians(10.0);
    private static final double ANGLE = Math.toRadians(30.0);
    private static final double FALL_MIN_ANGLE = Math.toRadians(60.0);
    private static final double FALL_MAX_ANGLE = Math.toRadians(105.0);

    private RayUtil() {
    }

    public static Collection<Ray> cone(User user, double range) {
        return RayUtil.createBurst(user, range, ANGLE_STEP, ANGLE);
    }

    public static Collection<Ray> sphere(User user, double range) {
        return RayUtil.createBurst(user, range, ANGLE_STEP, 0.0);
    }

    public static Collection<Ray> fall(User user, double range) {
        return RayUtil.createBurst(user, range, ANGLE_STEP, -1.0);
    }

    public static Collection<Ray> createBurst(User user, double range, double angleStep, double angle) {
        Vector3d center = user.center();
        Vector3d userDIr = user.direction();
        ArrayList<Ray> rays = new ArrayList<Ray>();
        for (double theta = 0.0; theta < 3.1405926535897932; theta += angleStep) {
            double z = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            for (double phi = 0.0; phi < 6.282185307179586; phi += angleStep) {
                double vectorAngle;
                double x = Math.cos(phi) * sinTheta;
                double y = Math.sin(phi) * sinTheta;
                Vector3d direction = Vector3d.of(x, y, z);
                if (angle > 0.0 && direction.angle(userDIr) > angle || angle < 0.0 && ((vectorAngle = direction.angle(Vector3d.PLUS_J)) < FALL_MIN_ANGLE || vectorAngle > FALL_MAX_ANGLE)) continue;
                rays.add(Ray.of(center, (Vector3d)direction.multiply(range)));
            }
        }
        return rays;
    }
}

