/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.collision.geometry;

import java.util.function.Supplier;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.util.functional.Suppliers;
import me.moros.math.Vector3d;

record RayImpl(Vector3d position, Vector3d direction, Supplier<Vector3d> invSupplier) implements Ray
{
    RayImpl(Vector3d position, Vector3d direction) {
        this(position, direction, Suppliers.lazy(() -> RayImpl.calculateInv(direction)));
    }

    @Override
    public Vector3d inv() {
        return this.invSupplier().get();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RayImpl other = (RayImpl)obj;
        return this.position.equals(other.position) && this.direction.equals(other.direction);
    }

    @Override
    public int hashCode() {
        int result = this.position.hashCode();
        result = 31 * result + this.direction.hashCode();
        return result;
    }

    private static Vector3d calculateInv(Vector3d dir) {
        double invX = dir.x() == 0.0 ? Double.MAX_VALUE : 1.0 / dir.x();
        double invY = dir.y() == 0.0 ? Double.MAX_VALUE : 1.0 / dir.y();
        double invZ = dir.z() == 0.0 ? Double.MAX_VALUE : 1.0 / dir.z();
        return Vector3d.of(invX, invY, invZ);
    }
}

