/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.collision.geometry;

import java.util.Arrays;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.OBB;
import me.moros.math.Position;
import me.moros.math.Rotation;
import me.moros.math.Vector3d;

record OBBImpl(Vector3d position, Vector3d extents, AABB outer, Vector3d[] axes) implements OBB
{
    @Override
    public Vector3d axis(int idx) {
        return this.axes[idx];
    }

    @Override
    public Vector3d localSpace(Vector3d v) {
        return OBBImpl.localSpace(this.axes, v);
    }

    @Override
    public Vector3d closestPosition(Vector3d target) {
        Vector3d t = (Vector3d)target.subtract(this.position);
        Vector3d closest = this.position;
        double[] extentArray = this.extents.toArray();
        for (int i = 0; i < 3; ++i) {
            Vector3d axis = this.axes[i];
            double r = extentArray[i];
            double dist = Math.clamp(t.dot(axis), -r, r);
            closest = (Vector3d)closest.add((Position)axis.multiply(dist));
        }
        return closest;
    }

    @Override
    public OBB at(Position point) {
        Vector3d point3d = point.toVector3d();
        return new OBBImpl(point3d, this.extents, this.outer.at(point3d), (Vector3d[])this.axes.clone());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OBBImpl other = (OBBImpl)obj;
        return this.position.equals(other.position) && this.extents.equals(other.extents) && Arrays.equals(this.axes, other.axes);
    }

    @Override
    public int hashCode() {
        int result = this.position.hashCode();
        result = 31 * result + this.extents.hashCode();
        result = 31 * result + Arrays.hashCode(this.axes);
        return result;
    }

    private static Vector3d localSpace(Vector3d[] axes, Vector3d dir) {
        return Vector3d.of(axes[0].dot(dir), axes[1].dot(dir), axes[2].dot(dir));
    }

    static OBB from(AABB aabb, Rotation rotation) {
        Vector3d center = rotation.applyTo(aabb.position());
        Vector3d e = aabb.halfExtents();
        double[][] m = rotation.getMatrix();
        Vector3d[] axes = new Vector3d[3];
        for (int i = 0; i < 3; ++i) {
            axes[i] = Vector3d.from(m[i]);
        }
        Vector3d halfExtents = OBBImpl.localSpace(axes, e).abs();
        return new OBBImpl(center, e, AABB.of((Vector3d)center.subtract(halfExtents), (Vector3d)center.add(halfExtents)), axes);
    }
}

