/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.collision.geometry;

import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.DiskImpl;
import me.moros.bending.api.collision.geometry.OBB;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.math.Position;
import me.moros.math.Vector3d;

public sealed interface Disk
extends Collider
permits DiskImpl {
    public Sphere sphere();

    public OBB obb();

    @Override
    default public Collider.Type type() {
        return Collider.Type.DISK;
    }

    @Override
    default public AABB outer() {
        AABB box1 = this.sphere().outer();
        AABB box2 = this.obb().outer();
        return AABB.of(box1.min().min(box2.min()), box1.max().max(box2.max()));
    }

    @Override
    default public Vector3d position() {
        return this.sphere().position();
    }

    @Override
    default public Disk at(Position point) {
        return Disk.of(this.sphere().at(point), this.obb().at(point));
    }

    @Override
    default public Vector3d halfExtents() {
        return this.obb().halfExtents();
    }

    @Override
    default public boolean contains(Vector3d point) {
        return this.sphere().contains(point) && this.obb().contains(point);
    }

    public static Disk of(Sphere sphere, OBB obb) {
        return new DiskImpl(sphere, obb);
    }
}

