/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.collision.geometry;

import me.moros.bending.api.collision.geometry.AABBDummy;
import me.moros.bending.api.collision.geometry.AABBImpl;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.math.Position;
import me.moros.math.Vector3d;

public sealed interface AABB
extends Collider
permits AABBImpl, AABBDummy {
    public static final AABB BLOCK_BOUNDS = AABB.of(Vector3d.ZERO, Vector3d.ONE);
    public static final AABB EXPANDED_BLOCK_BOUNDS = BLOCK_BOUNDS.grow(Vector3d.of(0.4, 0.4, 0.4));

    public Vector3d min();

    public Vector3d max();

    default public AABB grow(Vector3d diff) {
        return AABB.of((Vector3d)this.min().subtract(diff), (Vector3d)this.max().add(diff));
    }

    @Override
    default public Collider.Type type() {
        return Collider.Type.AABB;
    }

    @Override
    default public AABB outer() {
        return this;
    }

    @Override
    default public Vector3d position() {
        return (Vector3d)this.min().add(this.halfExtents());
    }

    @Override
    default public AABB at(Position point) {
        Vector3d halfExtents = this.halfExtents();
        Vector3d pos = point.toVector3d();
        return AABB.of((Vector3d)pos.subtract(halfExtents), (Vector3d)pos.add(halfExtents));
    }

    @Override
    default public Vector3d halfExtents() {
        return ((Vector3d)((Vector3d)this.max().subtract(this.min())).multiply(0.5)).abs();
    }

    @Override
    default public boolean contains(Vector3d point) {
        return point.x() >= this.min().x() && point.x() <= this.max().x() && point.y() >= this.min().y() && point.y() <= this.max().y() && point.z() >= this.min().z() && point.z() <= this.max().z();
    }

    public static AABB dummy() {
        return AABBDummy.INSTANCE;
    }

    public static AABB fromRay(Ray ray, double raySize) {
        return AABB.fromRay(ray.position(), ray.direction(), raySize);
    }

    public static AABB fromRay(Vector3d start, Vector3d dir, double raySize) {
        if (dir.lengthSq() == 0.0) {
            return AABB.dummy();
        }
        double offset = Math.max(0.0, raySize);
        double newMinX = start.x() - (dir.x() < 0.0 ? -dir.x() : 0.0) - offset;
        double newMinY = start.y() - (dir.y() < 0.0 ? -dir.y() : 0.0) - offset;
        double newMinZ = start.z() - (dir.z() < 0.0 ? -dir.z() : 0.0) - offset;
        double newMaxX = start.x() + (dir.x() > 0.0 ? dir.x() : 0.0) + offset;
        double newMaxY = start.y() + (dir.y() > 0.0 ? dir.y() : 0.0) + offset;
        double newMaxZ = start.z() + (dir.z() > 0.0 ? dir.z() : 0.0) + offset;
        return AABB.of(Vector3d.of(newMinX, newMinY, newMinZ), Vector3d.of(newMaxX, newMaxY, newMaxZ));
    }

    public static AABB of(Vector3d min, Vector3d max) {
        return new AABBImpl(min, max);
    }
}

