/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common.basic;

import java.util.function.Predicate;
import me.moros.bending.api.ability.SimpleAbility;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.Vector3i;
import me.moros.math.VectorUtil;
import org.jspecify.annotations.Nullable;

public abstract class BlockShot
implements Updatable,
SimpleAbility {
    private User user;
    private Vector3d location;
    private Vector3i previousBlock;
    private Block tempBlock;
    private AABB collider;
    private final Vector3d firstDestination;
    protected Predicate<Block> diagonalsPredicate = b -> !MaterialUtil.isTransparentOrWater(b);
    protected Vector3d target;
    protected Vector3d direction;
    protected BlockType type;
    private boolean settingUp;
    private int buffer;
    private final int speed;
    protected boolean allowUnderWater = false;
    protected final double range;

    protected BlockShot(User user, Block block, BlockType type, double range, int speed) {
        this.user = user;
        this.type = type;
        this.location = block.center();
        this.collider = AABB.EXPANDED_BLOCK_BOUNDS.at(this.location.floor());
        this.range = range;
        this.speed = Math.min(20, speed);
        this.buffer = speed;
        this.redirect();
        this.settingUp = true;
        int targetY = FastMath.floor(this.target.y());
        int currentY = block.blockY();
        Vector3d dir = (Vector3d)((Vector3d)this.target.subtract(this.location)).normalize().withY(0.0);
        boolean validAbove = !block.offset(Direction.UP).type().isCollidable();
        boolean validBelow = !block.offset(Direction.DOWN).type().isCollidable();
        Vector3d fixedY = (Vector3d)this.location.withY((double)targetY + 0.5);
        this.firstDestination = targetY > currentY && validAbove || targetY < currentY && validBelow ? fixedY : (!user.world().blockAt((Position)this.location.add(dir)).type().isCollidable() ? ((Vector3d)this.location.add(dir)).center() : (validAbove ? this.location.add(0.0, 2.0, 0.0) : (validBelow ? this.location.add(0.0, -2.0, 0.0) : fixedY)));
        this.direction = ((Vector3d)this.firstDestination.subtract(this.location)).normalize();
    }

    @Override
    public Updatable.UpdateResult update() {
        this.buffer += this.speed;
        if (this.buffer < 20) {
            return Updatable.UpdateResult.CONTINUE;
        }
        this.buffer -= 20;
        this.clean();
        if (Math.abs(this.location.y() - this.firstDestination.y()) < 0.5) {
            this.settingUp = false;
        }
        this.previousBlock = this.location.toVector3i();
        Vector3d dest = this.settingUp ? this.firstDestination : this.target;
        this.direction = ((Vector3d)dest.subtract((Position)this.location.subtract(this.direction))).normalize();
        Vector3d originalVector = this.location;
        Block originBlock = this.user.world().blockAt(originalVector);
        if (((Vector3d)this.location.add(this.direction)).toVector3i().equals(this.previousBlock)) {
            this.direction = (Vector3d)this.direction.multiply(2.0);
        }
        for (Vector3i v : VectorUtil.decomposeDiagonals(originalVector, this.direction)) {
            Block diagonal = originBlock.offset(v);
            if (!this.diagonalsPredicate.test(diagonal)) continue;
            this.onBlockHit(diagonal);
            return Updatable.UpdateResult.REMOVE;
        }
        if (((Vector3d)originalVector.add(this.direction)).distanceSq(this.user.eyeLocation()) > this.range * this.range) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.location = (Vector3d)this.location.add(this.direction);
        Block current = this.user.world().blockAt(this.location);
        if (!this.user.canBuild(current)) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.collider = AABB.EXPANDED_BLOCK_BOUNDS.at(this.location.floor());
        if (CollisionUtil.handle(this.user, this.collider, this)) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (MaterialUtil.isTransparent(current) || MaterialUtil.isWater(current) && this.allowUnderWater) {
            WorldUtil.tryBreakPlant(current);
            if (this.type == BlockType.WATER && MaterialUtil.isWater(current)) {
                ParticleBuilder.bubble(current).spawn(this.user.world());
                this.tempBlock = null;
            } else {
                this.tempBlock = current;
                TempBlock.builder(this.type).build(current);
            }
        } else {
            this.onBlockHit(current);
            return Updatable.UpdateResult.REMOVE;
        }
        this.postRender(this.center());
        if (this.location.distanceSq(this.target) < 0.8) {
            Block projected = this.user.world().blockAt((Position)this.location.add(this.direction));
            if (!MaterialUtil.isTransparent(projected)) {
                this.onBlockHit(projected);
            }
            return Updatable.UpdateResult.REMOVE;
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    public void redirect() {
        this.target = this.user.rayTrace(this.range).ignore(this.location).cast(this.user.world()).entityEyeLevelOrPosition().center();
        this.settingUp = false;
    }

    public @Nullable Block previousBlock() {
        return this.previousBlock == null ? null : this.user.world().blockAt(this.previousBlock);
    }

    public Vector3d center() {
        return this.location.center();
    }

    @Override
    public void render(Vector3d location) {
    }

    @Override
    public AABB collider() {
        return this.collider;
    }

    public boolean isValid(Block block) {
        if (this.type == BlockType.WATER) {
            return MaterialUtil.isWater(block);
        }
        return this.type == block.type();
    }

    public void clean() {
        if (this.tempBlock != null) {
            this.clean(this.tempBlock);
        }
    }

    public void clean(Block block) {
        if (this.isValid(block)) {
            TempBlock.air().build(block);
        }
    }

    public void user(User user) {
        this.user = user;
    }
}

