/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common.basic;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import me.moros.bending.api.ability.SimpleAbility;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.AbstractFlight;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Vector3d;
import org.jspecify.annotations.Nullable;

public abstract class AbstractSpout
extends AbstractFlight
implements Updatable,
SimpleAbility {
    protected final Set<Block> ignore = new HashSet<Block>();
    protected Predicate<Block> validBlock = x -> true;
    protected AABB collider;
    private final double height;
    protected double distance;

    protected AbstractSpout(User user, double height) {
        super(user);
        this.height = height;
    }

    @Override
    public Updatable.UpdateResult update() {
        this.resetSprintAndFall();
        double maxHeight = this.height + 2.0;
        Block block = AbstractSpout.blockCast(this.user.block(), maxHeight, this.ignore::contains);
        if (block == null || !this.validBlock.test(block)) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.distance = this.user.location().y() - block.y();
        if (this.distance > maxHeight) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.flight.flying(this.distance <= this.height);
        Vector3d pos = this.user.location().floor();
        this.collider = AABB.of(Vector3d.of(-0.5, -this.distance, -0.5), Vector3d.of(0.5, 0.0, 0.5)).at(pos);
        this.render(pos);
        this.postRender(pos);
        return Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public boolean onEntityHit(Entity entity) {
        return true;
    }

    @Override
    public boolean onBlockHit(Block block) {
        return true;
    }

    @Override
    public Collider collider() {
        return this.collider;
    }

    public void onDestroy() {
        this.cleanup();
    }

    public void limitVelocity(Vector3d velocity, double speed) {
        if (velocity.lengthSq() > speed * speed) {
            this.user.velocity((Vector3d)velocity.normalize().multiply(speed));
        }
    }

    public static @Nullable Block blockCast(Block origin, double distance) {
        return AbstractSpout.blockCast(origin, distance, b -> false);
    }

    public static @Nullable Block blockCast(Block origin, double distance, Predicate<Block> ignore) {
        int i = 0;
        while ((double)i < distance) {
            boolean isLiquid;
            Block check = origin.offset(Direction.DOWN, i);
            boolean bl = isLiquid = check.type().isLiquid() || MaterialUtil.isWaterPlant(check);
            if ((check.type().isCollidable() || isLiquid) && !ignore.test(check)) {
                return check;
            }
            ++i;
        }
        return null;
    }
}

