/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common.basic;

import java.util.function.Predicate;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.AbstractFlight;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Position;
import me.moros.math.Vector3d;

public abstract class AbstractRide
extends AbstractFlight
implements Updatable {
    private final HeightSmoother smoother;
    private final double speed;
    private final double targetHeight;
    private int stuckCount = 0;
    protected Predicate<Block> predicate = x -> true;

    protected AbstractRide(User user, double speed, double targetHeight) {
        super(user);
        this.speed = speed;
        this.targetHeight = targetHeight;
        this.smoother = new HeightSmoother();
    }

    @Override
    public Updatable.UpdateResult update() {
        Block check;
        this.resetSprintAndFall();
        int n = this.stuckCount = this.user.velocity().lengthSq() < 0.1 ? this.stuckCount + 1 : 0;
        if (this.stuckCount > 10 || this.isColliding()) {
            return Updatable.UpdateResult.REMOVE;
        }
        double height = this.user.distanceAboveGround(this.targetHeight + 2.0);
        this.flight.flying(height < this.targetHeight + 1.0);
        double smoothedHeight = this.smoother.add(height);
        if (smoothedHeight > this.targetHeight) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.user.block().type().isLiquid()) {
            height = 0.5;
        }
        if (!this.predicate.test(check = this.user.world().blockAt((Position)this.user.location().subtract(0.0, height + 0.05, 0.0)))) {
            return Updatable.UpdateResult.REMOVE;
        }
        double delta = this.getPrediction() - height;
        double force = Math.clamp(0.3 * delta, -1.0, 0.5);
        Vector3d velocity = (Vector3d)((Vector3d)((Vector3d)this.user.direction().withY(0.0)).normalize().multiply(this.speed)).withY(force);
        this.affect(velocity);
        this.render(check.state());
        this.postRender();
        return Updatable.UpdateResult.CONTINUE;
    }

    private boolean isColliding() {
        double playerSpeed = ((Vector3d)this.user.velocity().withY(0.0)).length();
        Vector3d direction = (Vector3d)((Vector3d)this.user.direction().withY(0.0)).normalize(Vector3d.ZERO).multiply(Math.max(this.speed, playerSpeed));
        Vector3d front = (Vector3d)((Vector3d)this.user.eyeLocation().subtract(0.0, 0.5, 0.0)).add(direction);
        Block block = this.user.world().blockAt(front);
        return !MaterialUtil.isTransparentOrWater(block) || block.type().isCollidable();
    }

    private double getPrediction() {
        double playerSpeed = ((Vector3d)this.user.velocity().withY(0.0)).length();
        Vector3d offset = (Vector3d)((Vector3d)this.user.direction().withY(0.0)).normalize().multiply(Math.max(this.speed, playerSpeed) * 3.0);
        if (this.user.world().nearbyBlocks(this.user.dimensions((Position)this.user.location().add(offset)), block -> true, 1).isEmpty()) {
            return Math.max(1.25, this.targetHeight - 2.0);
        }
        return this.targetHeight - 1.0;
    }

    public void onDestroy() {
        this.cleanup();
    }

    protected abstract void render(BlockState var1);

    protected abstract void postRender();

    protected abstract void affect(Vector3d var1);

    private static final class HeightSmoother {
        private static final int LENGTH = 10;
        private final double[] values = new double[10];
        private double sum = 0.0;
        private int index = 0;

        private HeightSmoother() {
        }

        private double add(double value) {
            double prev = this.values[this.index];
            this.values[this.index] = value;
            this.index = (this.index + 1) % 10;
            this.sum += value - prev;
            return this.sum / 10.0;
        }
    }
}

