/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common;

import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.state.State;
import me.moros.bending.api.ability.state.StateChain;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import org.jspecify.annotations.Nullable;

public class TravellingSource
implements State {
    private final BlockState state;
    private StateChain chain;
    private final User user;
    private Block source;
    private boolean started = false;
    private final double minDistanceSq;
    private final double maxDistanceSq;

    public TravellingSource(User user, BlockState state, double minDistance, double maxDistance) {
        this.user = user;
        this.state = state;
        this.minDistanceSq = minDistance * minDistance;
        this.maxDistanceSq = maxDistance * maxDistance;
    }

    @Override
    public void start(StateChain chain) {
        if (this.started) {
            return;
        }
        this.chain = chain;
        this.source = chain.chainStore().stream().findFirst().orElse(null);
        this.started = this.source != null;
    }

    @Override
    public void complete() {
        if (!this.started) {
            return;
        }
        this.chain.chainStore().clear();
        this.chain.chainStore().add(this.source);
        this.chain.nextState();
    }

    @Override
    public Updatable.UpdateResult update() {
        if (!this.started) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.clean();
        Vector3d target = this.user.location().center();
        Vector3d location = this.source.center();
        double distSq = target.distanceSq(location);
        if (this.maxDistanceSq > this.minDistanceSq && distSq > this.maxDistanceSq) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (target.distanceSq(location) < this.minDistanceSq) {
            this.complete();
            return Updatable.UpdateResult.CONTINUE;
        }
        int y = this.user.eyeLocation().blockY();
        if (this.isValid(this.source.offset(Direction.UP)) && this.source.y() < (double)y) {
            this.source = this.source.offset(Direction.UP);
        } else if (this.isValid(this.source.offset(Direction.DOWN)) && this.source.y() > (double)y) {
            this.source = this.source.offset(Direction.DOWN);
        } else {
            Vector3d direction = ((Vector3d)target.subtract(location)).normalize();
            Block nextBlock = this.user.world().blockAt((Position)location.add(direction));
            this.source = this.source.equals(nextBlock) ? this.findPath(nextBlock) : nextBlock;
        }
        if (this.source == null || !this.isValid(this.source) || !this.user.canBuild(this.source)) {
            return Updatable.UpdateResult.REMOVE;
        }
        TempBlock.builder(this.state).duration(200L).build(this.source);
        return Updatable.UpdateResult.CONTINUE;
    }

    private @Nullable Block findPath(Block check) {
        Vector3d dest = this.user.eyeLocation().center();
        Block result = null;
        double minDistance = Double.MAX_VALUE;
        for (Direction face : WorldUtil.SIDES) {
            double d;
            Block block = check.offset(face);
            if (!this.isValid(block) || !((d = block.center().distanceSq(dest)) < minDistance)) continue;
            minDistance = d;
            result = block;
        }
        return result;
    }

    private boolean isValid(Block block) {
        if (!TempBlock.isBendable(block)) {
            return false;
        }
        if (this.state.type() == BlockType.WATER) {
            return MaterialUtil.isTransparentOrWater(block);
        }
        return MaterialUtil.isTransparent(block);
    }

    private void clean() {
        if (this.state.type() == this.source.type()) {
            TempBlock.air().build(this.source);
        }
    }
}

