/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common;

import java.util.HashMap;
import java.util.Map;
import me.moros.bending.api.ability.common.SelectedSource;
import me.moros.bending.api.ability.common.SelectedSourceImpl;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;

class SelectedSourceWithState
extends SelectedSourceImpl
implements SelectedSource.WithState {
    static final Map<Block, SelectedSource.WithState> INSTANCES = new HashMap<Block, SelectedSource.WithState>();
    private TempBlock.Snapshot snapshot;

    SelectedSourceWithState(User user, Block block, double maxDistance, BlockState state) {
        super(user, block, maxDistance);
        this.updateSnapshot(state);
    }

    @Override
    public boolean reselect(Block block, BlockState state) {
        if (super.reselect(block)) {
            this.updateSnapshot(state);
            return true;
        }
        return false;
    }

    private void updateSnapshot(BlockState state) {
        this.type = state.type();
        this.snapshot = TempBlock.MANAGER.get(this.block).map(TempBlock::snapshot).orElse(null);
        TempBlock.builder(state).build(this.block);
        INSTANCES.put(this.block, this);
    }

    @Override
    protected void render() {
    }

    @Override
    public void onDestroy() {
        if (this.block.type() == this.type) {
            TempBlock.revertToSnapshot(this.block, this.snapshot);
        }
        INSTANCES.remove(this.block);
    }
}

