/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.SelectedSource;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Vector3d;

public class Pillar
implements Updatable,
Iterable<Block> {
    private final User user;
    private final Block origin;
    private final Direction direction;
    private final Collection<Block> pillarBlocks;
    private final Predicate<Block> predicate;
    private final int length;
    private final int distance;
    private final long interval;
    private final long duration;
    private int currentDistance;
    private long nextUpdateTime;

    protected <T extends Pillar> Pillar(Builder<T> builder) {
        this.user = builder.user;
        this.origin = builder.origin;
        this.direction = builder.direction;
        this.length = builder.length;
        this.distance = builder.distance;
        this.interval = builder.interval;
        this.duration = builder.duration;
        this.predicate = builder.predicate;
        this.pillarBlocks = new ArrayList<Block>(this.length);
        this.currentDistance = 0;
        this.nextUpdateTime = 0L;
    }

    @Override
    public Updatable.UpdateResult update() {
        Block currentIndex;
        if (this.currentDistance >= this.distance) {
            return Updatable.UpdateResult.REMOVE;
        }
        Vector3d pos = this.origin.offset(this.direction.opposite(), this.length - this.currentDistance).center();
        AABB collider = this.createPillarBox(pos, (double)this.length + 0.35);
        CollisionUtil.handle(this.user, collider, this::onEntityHit, false, true);
        long time = System.currentTimeMillis();
        if (time < this.nextUpdateTime) {
            return Updatable.UpdateResult.CONTINUE;
        }
        this.nextUpdateTime = time + this.interval;
        return this.move(currentIndex = this.origin.offset(this.direction, ++this.currentDistance)) ? Updatable.UpdateResult.CONTINUE : Updatable.UpdateResult.REMOVE;
    }

    private boolean move(Block newBlock) {
        if (MaterialUtil.isLava(newBlock)) {
            return false;
        }
        if (!MaterialUtil.isTransparentOrWater(newBlock)) {
            return false;
        }
        WorldUtil.tryBreakPlant(newBlock);
        SelectedSource.tryRevertSource(newBlock.offset(this.direction.opposite()));
        for (int i = 0; i < this.length; ++i) {
            Block forwardBlock = newBlock.offset(this.direction, -i);
            Block backwardBlock = forwardBlock.offset(this.direction.opposite());
            if (!this.predicate.test(backwardBlock)) {
                TempBlock.air().duration(this.duration).build(forwardBlock);
                this.playSound(forwardBlock);
                return false;
            }
            BlockType type = MaterialUtil.solidType(TempBlock.getLastValidType(backwardBlock));
            TempBlock.builder(type).bendable(true).duration(this.duration).build(forwardBlock);
        }
        this.pillarBlocks.add(newBlock);
        TempBlock.air().duration(this.duration).build(newBlock.offset(this.direction, -this.length));
        this.playSound(newBlock);
        return true;
    }

    private Vector3d withComponentInDirection(Vector3d vector, Direction dir, double factor) {
        return switch (dir) {
            case Direction.EAST, Direction.WEST -> (Vector3d)vector.withX((double)this.direction.blockX() * factor);
            case Direction.NORTH, Direction.SOUTH -> (Vector3d)vector.withZ((double)this.direction.blockZ() * factor);
            default -> (Vector3d)vector.withY((double)this.direction.blockY() * factor);
        };
    }

    public AABB createPillarBox(Vector3d pos, double len) {
        Vector3d xMin = Vector3d.of(-0.5, -0.5, -0.5);
        Vector3d xMax = Vector3d.of(len + 0.5, 0.5, 0.5);
        Vector3d yMin = Vector3d.of(-0.5, -0.5, -0.5);
        Vector3d yMax = Vector3d.of(0.5, len + 0.5, 0.5);
        Vector3d zMin = Vector3d.of(-0.5, -0.5, -0.5);
        Vector3d zMax = Vector3d.of(0.5, 0.5, len + 0.5);
        return switch (this.direction) {
            default -> throw new MatchException(null, null);
            case Direction.EAST -> AABB.of((Vector3d)pos.add(xMin), (Vector3d)pos.add(xMax));
            case Direction.WEST -> AABB.of((Vector3d)pos.add(xMax.negate()), (Vector3d)pos.add(xMin.negate()));
            case Direction.UP -> AABB.of((Vector3d)pos.add(yMin), (Vector3d)pos.add(yMax));
            case Direction.DOWN -> AABB.of((Vector3d)pos.add(yMax.negate()), (Vector3d)pos.add(yMin.negate()));
            case Direction.NORTH -> AABB.of((Vector3d)pos.add(zMin), (Vector3d)pos.add(zMax));
            case Direction.SOUTH -> AABB.of((Vector3d)pos.add(zMax.negate()), (Vector3d)pos.add(zMin.negate()));
        };
    }

    @Override
    public Iterator<Block> iterator() {
        return Collections.unmodifiableCollection(this.pillarBlocks).iterator();
    }

    public Collection<Block> pillarBlocks() {
        return List.copyOf(this.pillarBlocks);
    }

    public Block origin() {
        return this.origin;
    }

    public void playSound(Block block) {
        SoundEffect.EARTH.play(block);
    }

    public boolean onEntityHit(Entity entity) {
        double factor = 0.75 * ((double)this.length - 0.4 * (double)this.currentDistance) / (double)this.length;
        Vector3d vel = this.withComponentInDirection(entity.velocity(), this.direction, factor);
        entity.velocity(vel);
        return true;
    }

    public static Builder<Pillar> builder(User user, Block origin) {
        return Pillar.builder(user, origin, Pillar::new);
    }

    public static <T extends Pillar> Builder<T> builder(User user, Block origin, Function<Builder<T>, T> constructor) {
        return new Builder<T>(user, origin, constructor);
    }

    public static final class Builder<T extends Pillar> {
        private final User user;
        private final Block origin;
        private final Function<Builder<T>, T> constructor;
        private Direction direction = Direction.UP;
        private int length;
        private int distance;
        private long interval = 125L;
        private long duration = BendingProperties.instance().earthRevertTime();
        private Predicate<Block> predicate = b -> true;

        private Builder(User user, Block origin, Function<Builder<T>, T> constructor) {
            this.user = user;
            this.origin = origin;
            this.constructor = constructor;
        }

        public Builder<T> direction(Direction direction) {
            if (!WorldUtil.FACES.contains(direction)) {
                throw new IllegalStateException("Pillar direction must be one of the 6 main BlockFaces.");
            }
            this.direction = direction;
            return this;
        }

        public Builder<T> interval(long interval) {
            this.interval = Math.max(0L, interval);
            return this;
        }

        public Builder<T> duration(long duration) {
            this.duration = Math.max(0L, duration);
            return this;
        }

        public Builder<T> predicate(Predicate<Block> predicate) {
            this.predicate = predicate;
            return this;
        }

        public Optional<T> build(int length) {
            return this.build(length, length);
        }

        public Optional<T> build(int length, int distance) {
            int maxLength = this.validateLength(length);
            if (maxLength < 1) {
                return Optional.empty();
            }
            int maxDistance = this.validateDistance(distance);
            if (maxDistance < 1) {
                return Optional.empty();
            }
            this.length = maxLength;
            this.distance = Math.min(maxLength, maxDistance);
            return Optional.of((Pillar)this.constructor.apply(this));
        }

        private int validateLength(int max) {
            for (int i = 0; i < max; ++i) {
                Block backwardBlock = this.origin.offset(this.direction.opposite(), i);
                if (TempBlock.isBendable(backwardBlock) && this.user.canBuild(backwardBlock) && this.predicate.test(backwardBlock)) continue;
                return i;
            }
            return max;
        }

        private int validateDistance(int max) {
            for (int i = 0; i < max; ++i) {
                Block forwardBlock = this.origin.offset(this.direction, i + 1);
                if (this.user.canBuild(forwardBlock)) continue;
                return i;
            }
            return max;
        }
    }
}

