/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Predicate;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.temporal.TempEntity;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.data.DataKey;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;
import org.jspecify.annotations.Nullable;

public class FragileStructure
implements Iterable<Block> {
    public static final DataKey<FragileStructure> DESTRUCTIBLE = KeyUtil.data("destructible", FragileStructure.class);
    private final Collection<Block> fragileBlocks;
    private final Predicate<Block> predicate;
    private final boolean fallingBlocks;
    private int health;

    protected <T extends FragileStructure> FragileStructure(Builder<T> builder) {
        this.fragileBlocks = Set.copyOf(builder.blocks);
        this.predicate = builder.predicate;
        this.fallingBlocks = builder.fallingBlocks;
        this.health = builder.health;
        this.fragileBlocks.forEach(b -> b.add(DESTRUCTIBLE, this));
    }

    public int health() {
        return this.health;
    }

    private int damageStructure(int damage, Ray ray) {
        if (damage > 0 && this.health > damage) {
            this.health -= damage;
            return this.health;
        }
        this.destroyStructure(ray);
        return 0;
    }

    private void destroyStructure(Ray ray) {
        for (Block block : this.fragileBlocks) {
            block.remove(DESTRUCTIBLE);
            if (!this.predicate.test(block)) continue;
            this.onDestroy(block, ray);
        }
    }

    protected void onDestroy(Block block, Ray ray) {
        BlockType type = block.type();
        TempBlock.air().build(block);
        type.asParticle(block.center()).count(2).offset(0.3).spawn(block.world());
        if (ThreadLocalRandom.current().nextInt(3) == 0) {
            type.soundGroup().breakSound().asEffect(2.0f, 1.0f).play(block);
        }
        if (this.fallingBlocks) {
            Vector3d dir = (Vector3d)((Vector3d)ray.position().add((Position)ray.direction().normalize().multiply(8.0))).subtract(block.center());
            Vector3d velocity = VectorUtil.gaussianOffset((Vector3d)dir.normalize().multiply(0.3), 0.05);
            ((TempEntity.FallingBlockBuilder)((TempEntity.FallingBlockBuilder)TempEntity.fallingBlock(type.defaultState()).velocity(velocity)).duration(3000L)).build(block);
        }
    }

    public static boolean tryDamageStructure(Block block, int damage, Ray ray) {
        return FragileStructure.tryDamageStructure(List.of(block), damage, ray);
    }

    public static boolean tryDamageStructure(Iterable<Block> blocks, int damage, Ray ray) {
        for (Block block : blocks) {
            FragileStructure structure = block.get(DESTRUCTIBLE).orElse(null);
            if (structure == null) continue;
            structure.damageStructure(damage, ray);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Block> iterator() {
        return this.fragileBlocks.iterator();
    }

    public static Builder<FragileStructure> builder() {
        return FragileStructure.builder(FragileStructure::new);
    }

    public static <T extends FragileStructure> Builder<T> builder(Function<Builder<T>, T> constructor) {
        return new Builder<T>(constructor);
    }

    public static final class Builder<T extends FragileStructure> {
        private final Function<Builder<T>, T> constructor;
        private final Collection<Block> blocks = new ArrayList<Block>();
        private Predicate<Block> predicate;
        private boolean fallingBlocks;
        private int health = 10;

        private Builder(Function<Builder<T>, T> constructor) {
            this.constructor = constructor;
        }

        public Builder<T> fallingBlocks(boolean fallingBlocks) {
            this.fallingBlocks = fallingBlocks;
            return this;
        }

        public Builder<T> health(int health) {
            this.health = Math.max(1, health);
            return this;
        }

        public Builder<T> predicate(Predicate<Block> predicate) {
            this.predicate = Objects.requireNonNull(predicate);
            return this;
        }

        public Builder<T> add(Collection<Block> blocks) {
            this.blocks.addAll(List.copyOf(blocks));
            return this;
        }

        public @Nullable FragileStructure build() {
            if (this.blocks.isEmpty() || this.predicate == null) {
                return null;
            }
            return (FragileStructure)this.constructor.apply(this);
        }
    }
}

