/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.util.Tasker;
import me.moros.math.FastMath;
import org.jspecify.annotations.Nullable;

public class Fracture
implements Updatable {
    private final Collection<Block> wall;
    private final Collection<Block> weakened;
    private final Map<Block, Integer> wallData;
    private final FragileStructure.Builder<?> fragileBuilder;
    private final long interval;
    private long nextUpdateTime;

    protected <T extends Fracture> Fracture(Builder<T> builder) {
        this.wall = builder.blocks.stream().sorted(Comparator.comparingInt(Block::blockY)).collect(Collectors.toList());
        this.weakened = new HashSet<Block>();
        this.wallData = this.wall.stream().collect(Collectors.toMap(Function.identity(), k -> -1));
        this.fragileBuilder = builder.fragileBuilder;
        this.interval = builder.interval;
    }

    @Override
    public Updatable.UpdateResult update() {
        Iterator<Block> iterator;
        if (this.interval > 50L) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.nextUpdateTime) {
                return Updatable.UpdateResult.CONTINUE;
            }
            this.nextUpdateTime = currentTime + this.interval;
        }
        if ((iterator = this.wall.iterator()).hasNext()) {
            Block block = iterator.next();
            int offset = 1;
            int maxY = block.blockY();
            while (block != null) {
                int y;
                int n = y = ThreadLocalRandom.current().nextBoolean() ? maxY : maxY + offset;
                if (block.blockY() <= y && this.tryBreakBlock(block)) {
                    iterator.remove();
                    TempBlock.builder(BlockType.MAGMA_BLOCK).build(block);
                    this.weakened.add(block);
                    this.wallData.remove(block);
                } else if (block.blockY() > maxY + offset) break;
                block = iterator.hasNext() ? iterator.next() : null;
            }
        }
        if (this.wall.isEmpty()) {
            FragileStructure structure;
            if (this.fragileBuilder != null && (structure = this.fragileBuilder.add(this.weakened).build()) != null) {
                Tasker.sync().submit(() -> FragileStructure.tryDamageStructure(this.weakened, 0, Ray.ZERO), 200);
            }
            return Updatable.UpdateResult.REMOVE;
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private boolean tryBreakBlock(Block block) {
        int progress = this.wallData.computeIfPresent(block, (k, v) -> v + 1);
        int particles = FastMath.floor(0.5 * (double)progress);
        Particle.LAVA.builder(block.center()).count(particles).offset(0.4).spawn(block.world());
        if (progress <= 9) {
            Platform.instance().nativeAdapter().fakeBreak(block, (byte)progress).broadcast(block.world(), block);
            return false;
        }
        return true;
    }

    public static Builder<Fracture> builder() {
        return Fracture.builder(Fracture::new);
    }

    public static <T extends Fracture> Builder<T> builder(Function<Builder<T>, T> constructor) {
        return new Builder<T>(constructor);
    }

    public static final class Builder<T extends Fracture> {
        private final Function<Builder<T>, T> constructor;
        private final Collection<Block> blocks = new ArrayList<Block>();
        private FragileStructure.Builder<?> fragileBuilder;
        private long interval = 0L;

        private Builder(Function<Builder<T>, T> constructor) {
            this.constructor = constructor;
        }

        public Builder<T> interval(long interval) {
            this.interval = Math.max(0L, interval);
            return this;
        }

        public Builder<T> add(Collection<Block> blocks) {
            this.blocks.addAll(List.copyOf(blocks));
            return this;
        }

        public Builder<T> fragile(@Nullable FragileStructure.Builder<?> fragileBuilder) {
            this.fragileBuilder = fragileBuilder;
            return this;
        }

        public @Nullable Fracture build() {
            if (this.blocks.isEmpty()) {
                return null;
            }
            return (Fracture)this.constructor.apply(this);
        }
    }
}

