/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.SequenceBuilder;
import me.moros.bending.api.ability.SequenceStep;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.collect.ElementSet;
import me.moros.bending.api.util.functional.Suppliers;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.translation.Translatable;

public sealed class AbilityDescription
implements Keyed,
Translatable {
    private final Key key;
    private final ElementSet elements;
    private final Component displayName;
    private final Function<AbilityDescription, ? extends Ability> constructor;
    private final EnumSet<Activation> activations;
    private final Collection<String> requiredPermissions;
    private final boolean canBind;
    private final boolean hidden;
    private final boolean bypassCooldown;
    private final int hashcode;

    private AbilityDescription(Builder builder) {
        this.key = builder.key;
        this.elements = ElementSet.copyOf(builder.elements);
        this.displayName = builder.displayName;
        this.constructor = builder.constructor;
        this.activations = builder.activations;
        this.requiredPermissions = List.copyOf(builder.requiredPermissions);
        this.canBind = builder.canBind && !this.isActivatedBy(Activation.SEQUENCE);
        this.hidden = builder.hidden;
        this.bypassCooldown = builder.bypassCooldown;
        this.hashcode = Objects.hash(this.key, this.elements, this.activations);
    }

    public Component displayName() {
        return this.displayName;
    }

    public Set<Element> elements() {
        return this.elements;
    }

    public boolean canBind() {
        return this.canBind;
    }

    public boolean hidden() {
        return this.hidden;
    }

    public boolean bypassCooldown() {
        return this.bypassCooldown;
    }

    public boolean isActivatedBy(Activation method) {
        return this.activations.contains((Object)method);
    }

    public Ability createAbility() {
        return this.constructor.apply(this);
    }

    public Collection<String> permissions() {
        return this.requiredPermissions;
    }

    public Key key() {
        return this.key;
    }

    public String translationKey() {
        return this.key().namespace() + ".ability." + this.key().value();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbilityDescription other = (AbilityDescription)obj;
        return this.key.equals((Object)other.key) && this.elements.equals(other.elements) && this.activations.equals(other.activations);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public static <T extends Ability> Builder builder(String name, Function<AbilityDescription, T> constructor) {
        return AbilityDescription.builder("bending", name, constructor);
    }

    public static <T extends Ability> Builder builder(String namespace, String name, Function<AbilityDescription, T> constructor) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(name);
        Objects.requireNonNull(constructor);
        if (namespace.isEmpty()) {
            namespace = "bending";
        }
        boolean validName = name.chars().allMatch(c -> c >= 97 && c <= 122 || c >= 65 && c <= 90);
        if (name.isEmpty() || !validName) {
            throw new IllegalArgumentException("Name must be an alphabetical non-empty string.");
        }
        return new Builder(namespace, name, constructor);
    }

    public static final class Builder {
        private final Key key;
        private final String name;
        private Component displayName;
        private final ElementSet elements = ElementSet.mutable();
        private final Function<AbilityDescription, ? extends Ability> constructor;
        private EnumSet<Activation> activations;
        private Collection<String> requiredPermissions;
        private boolean canBind = true;
        private boolean hidden = false;
        private boolean bypassCooldown = false;

        private <T extends Ability> Builder(String namespace, String name, Function<AbilityDescription, T> constructor) {
            this.key = Key.key((String)namespace, (String)name.toLowerCase(Locale.ROOT));
            this.name = name;
            this.constructor = constructor;
            this.requiredPermissions = List.of(this.defaultPermission());
        }

        public Builder displayName(Component displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder element(Element element) {
            this.elements.add(element);
            return this;
        }

        public Builder element(Element first, Element ... elements) {
            this.elements.add(first);
            if (elements != null) {
                this.elements.addAll(List.of(elements));
            }
            return this;
        }

        public Builder activation(Activation method, Activation ... methods) {
            ArrayList<Activation> c = new ArrayList<Activation>();
            if (methods != null) {
                c.addAll(List.of(methods));
            }
            c.add(method);
            this.activations = EnumSet.copyOf(c);
            return this;
        }

        public Builder require(String ... permissions) {
            LinkedHashSet<String> c = new LinkedHashSet<String>();
            c.add(this.defaultPermission());
            if (permissions != null) {
                c.addAll(List.of(permissions));
            }
            this.requiredPermissions = c;
            return this;
        }

        public Builder canBind(boolean canBind) {
            this.canBind = canBind;
            return this;
        }

        public Builder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder bypassCooldown(boolean bypassCooldown) {
            this.bypassCooldown = bypassCooldown;
            return this;
        }

        public AbilityDescription build() {
            this.validate();
            if (this.activations.contains((Object)Activation.SEQUENCE)) {
                throw new IllegalStateException("Can't build sequence");
            }
            return new AbilityDescription(this);
        }

        public Sequence buildSequence(UnaryOperator<SequenceBuilder> function) {
            this.validate();
            if (!this.activations.contains((Object)Activation.SEQUENCE)) {
                throw new IllegalStateException("Ability must be activated by sequence");
            }
            List<SequenceStep> sequenceSteps = ((SequenceBuilder)function.apply(new SequenceBuilder())).validateAndBuild();
            return new Sequence(this, sequenceSteps);
        }

        private void validate() {
            if (this.elements.isEmpty()) {
                throw new IllegalStateException("Elements cannot be empty");
            }
            Objects.requireNonNull(this.activations, "Activations cannot be null");
            if (this.activations.isEmpty()) {
                throw new IllegalStateException("Activation methods cannot be empty");
            }
            if (this.displayName == null) {
                TextColor color = this.elements.size() > 2 ? ColorPalette.AVATAR : ((Element)((Object)this.elements.iterator().next())).color();
                this.displayName = Component.text((String)this.name, (TextColor)color);
            }
        }

        private String defaultPermission() {
            return this.key.namespace() + ".ability." + this.key.value();
        }
    }

    public static final class Sequence
    extends AbilityDescription {
        public static final int MAX_STEPS = 16;
        private final List<SequenceStep> steps;
        private final Supplier<Component> instructions;

        private Sequence(Builder builder, List<SequenceStep> steps) {
            super(builder);
            this.steps = List.copyOf(steps);
            this.instructions = Suppliers.lazy(this::generateInstructions);
        }

        public List<SequenceStep> steps() {
            return this.steps;
        }

        public Component instructions() {
            return this.instructions.get();
        }

        private Component generateInstructions() {
            TextComponent.Builder builder = Component.text();
            int size = this.steps.size();
            for (int i = 0; i < size; ++i) {
                SequenceStep next;
                SequenceStep sequenceStep = this.steps.get(i);
                if (i != 0) {
                    builder.append((Component)Component.text((String)" > "));
                }
                AbilityDescription desc = sequenceStep.ability();
                Activation action = sequenceStep.activation();
                String key = action.translationKey();
                if (action == Activation.SNEAK && i + 1 < this.steps.size() && desc.equals((next = this.steps.get(i + 1)).ability()) && next.activation() == Activation.SNEAK_RELEASE) {
                    key = "bending.activation.sneak-tap";
                    ++i;
                }
                ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.append(desc.displayName())).append((Component)Component.text((String)" ("))).append((Component)Component.translatable((String)key))).append((Component)Component.text((String)")"));
            }
            return builder.build();
        }

        public boolean matches(List<SequenceStep> otherSteps) {
            int sequenceLength;
            int actionsLength = otherSteps.size() - 1;
            if (actionsLength < (sequenceLength = this.steps.size() - 1)) {
                return false;
            }
            for (int i = 0; i <= sequenceLength; ++i) {
                SequenceStep second;
                SequenceStep first = this.steps.get(sequenceLength - i);
                if (first.equals(second = otherSteps.get(actionsLength - i))) continue;
                return false;
            }
            return true;
        }
    }
}

