/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.inventoryframework.pane;

import bending.libraries.inventoryframework.gui.GuiItem;
import bending.libraries.inventoryframework.gui.InventoryComponent;
import bending.libraries.inventoryframework.gui.type.util.Gui;
import bending.libraries.inventoryframework.pane.OutlinePane;
import bending.libraries.inventoryframework.pane.util.Mask;
import bending.libraries.inventoryframework.pane.util.Slot;
import bending.libraries.inventoryframework.util.UUIDTagType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Pane {
    @Deprecated
    protected int x = 0;
    @Deprecated
    protected int y = 0;
    @NotNull
    protected Slot slot = Slot.fromXY(0, 0);
    protected int length;
    protected int height;
    private boolean visible;
    @NotNull
    private Priority priority;
    @Nullable
    protected Consumer<InventoryClickEvent> onClick;
    protected UUID uuid;
    @NotNull
    private static final Map<String, Function<String, Object>> PROPERTY_MAPPINGS = new HashMap<String, Function<String, Object>>();

    protected Pane(@NotNull Slot slot, int length, int height, @NotNull Priority priority) {
        if (length == 0 || height == 0) {
            throw new IllegalArgumentException("Length and height of pane must be greater than zero");
        }
        this.setSlot(slot);
        this.length = length;
        this.height = height;
        this.priority = priority;
        this.visible = true;
        this.uuid = UUID.randomUUID();
    }

    protected Pane(int x, int y, int length, int height, @NotNull Priority priority) {
        this(Slot.fromXY(x, y), length, height, priority);
    }

    protected Pane(int length, int height) {
        if (length == 0 || height == 0) {
            throw new IllegalArgumentException("Length and height of pane must be greater than zero");
        }
        this.length = length;
        this.height = height;
        this.priority = Priority.NORMAL;
        this.visible = true;
        this.uuid = UUID.randomUUID();
    }

    protected Pane(Slot slot, int length, int height) {
        this(slot, length, height, Priority.NORMAL);
    }

    protected Pane(int x, int y, int length, int height) {
        this(x, y, length, height, Priority.NORMAL);
    }

    @NotNull
    @Contract(pure=true)
    public Pane copy() {
        throw new UnsupportedOperationException("The implementing pane hasn't overridden the copy method");
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setSlot(@NotNull Slot slot) {
        this.slot = slot;
        this.x = slot.getX(1);
        this.y = slot.getY(1);
    }

    public void setX(int x) {
        this.x = x;
        this.slot = Slot.fromXY(x, this.getY());
    }

    public void setY(int y) {
        this.y = y;
        this.slot = Slot.fromXY(this.getX(), y);
    }

    @Contract(pure=true)
    public int getLength() {
        return this.length;
    }

    @Contract(pure=true)
    public int getHeight() {
        return this.height;
    }

    @NotNull
    @Contract(pure=true)
    public UUID getUUID() {
        return this.uuid;
    }

    @NotNull
    @Contract(pure=true)
    public Slot getSlot() {
        return this.slot;
    }

    @Deprecated
    @Contract(pure=true)
    public int getX() {
        return this.x;
    }

    @Deprecated
    @Contract(pure=true)
    public int getY() {
        return this.y;
    }

    public abstract void display(@NotNull InventoryComponent var1, int var2, int var3, int var4, int var5);

    @Contract(pure=true)
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public abstract boolean click(@NotNull Gui var1, @NotNull InventoryComponent var2, @NotNull InventoryClickEvent var3, int var4, int var5, int var6, int var7, int var8);

    public void setPriority(@NotNull Priority priority) {
        this.priority = priority;
    }

    @Contract(pure=true)
    protected static boolean matchesItem(@NotNull GuiItem guiItem, @NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return guiItem.getUUID().equals(meta.getPersistentDataContainer().get(guiItem.getKey(), (PersistentDataType)UUIDTagType.INSTANCE));
    }

    @Nullable
    @Contract(pure=true)
    protected static <T extends GuiItem> T findMatchingItem(@NotNull Collection<T> items, @NotNull ItemStack item) {
        for (GuiItem guiItem : items) {
            if (!Pane.matchesItem(guiItem, item)) continue;
            return (T)guiItem;
        }
        return null;
    }

    @NotNull
    public Priority getPriority() {
        return this.priority;
    }

    @NotNull
    @Contract(pure=true)
    public abstract Collection<GuiItem> getItems();

    @NotNull
    @Contract(pure=true)
    public abstract Collection<Pane> getPanes();

    public abstract void clear();

    public void setOnClick(@Nullable Consumer<InventoryClickEvent> onClick) {
        this.onClick = onClick;
    }

    protected void callOnClick(@NotNull InventoryClickEvent event) {
        if (this.onClick == null) {
            return;
        }
        try {
            this.onClick.accept(event);
        }
        catch (Throwable t) {
            throw new RuntimeException("Exception while handling click event in inventory '" + event.getView().getTitle() + "', slot=" + event.getSlot() + ", for " + this.getClass().getSimpleName() + ", x=" + this.getX() + ", y=" + this.getY() + ", length=" + this.length + ", height=" + this.height, t);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static Pane createBorder(Slot slot, int length, int height, @NotNull GuiItem item) {
        if (length < 0) {
            throw new IllegalArgumentException("Length should be non-negative");
        }
        if (height < 0) {
            throw new IllegalArgumentException("Height should be non-negative");
        }
        String[] mask = new String[height];
        if (height > 0) {
            mask[0] = Pane.createLine(length);
        }
        if (height > 1) {
            mask[height - 1] = Pane.createLine(length);
        }
        for (int yIndex = 1; yIndex < height - 1; ++yIndex) {
            StringBuilder builder = new StringBuilder("1");
            for (int i = 0; i < length - 2; ++i) {
                builder.append('0');
            }
            mask[yIndex] = builder.append('1').toString();
        }
        OutlinePane pane = new OutlinePane(slot, length, height);
        pane.applyMask(new Mask(mask));
        pane.addItem(item);
        pane.setRepeat(true);
        return pane;
    }

    @NotNull
    @Contract(pure=true)
    public static Pane createBorder(int x, int y, int length, int height, @NotNull GuiItem item) {
        return Pane.createBorder(Slot.fromXY(x, y), length, height, item);
    }

    public static void registerProperty(@NotNull String attributeName, @NotNull Function<String, Object> function) {
        if (PROPERTY_MAPPINGS.containsKey(attributeName)) {
            throw new IllegalArgumentException("property '" + attributeName + "' is already registered");
        }
        PROPERTY_MAPPINGS.put(attributeName, function);
    }

    @NotNull
    @Contract(pure=true)
    private static String createLine(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length should be non-negative");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append('1');
        }
        return builder.toString();
    }

    static {
        PROPERTY_MAPPINGS.put("boolean", Boolean::parseBoolean);
        PROPERTY_MAPPINGS.put("byte", Byte::parseByte);
        PROPERTY_MAPPINGS.put("character", value -> Character.valueOf(value.charAt(0)));
        PROPERTY_MAPPINGS.put("double", Double::parseDouble);
        PROPERTY_MAPPINGS.put("float", Float::parseFloat);
        PROPERTY_MAPPINGS.put("integer", Integer::parseInt);
        PROPERTY_MAPPINGS.put("long", Long::parseLong);
        PROPERTY_MAPPINGS.put("short", Short::parseShort);
        PROPERTY_MAPPINGS.put("string", value -> value);
    }

    public static enum Priority {
        LOWEST{

            @Override
            public boolean isLessThan(@NotNull Priority priority) {
                return priority != this;
            }
        }
        ,
        LOW{

            @Override
            public boolean isLessThan(@NotNull Priority priority) {
                return priority != this && priority != LOWEST;
            }
        }
        ,
        NORMAL{

            @Override
            public boolean isLessThan(@NotNull Priority priority) {
                return priority != this && priority != LOW && priority != LOWEST;
            }
        }
        ,
        HIGH{

            @Override
            public boolean isLessThan(@NotNull Priority priority) {
                return priority == HIGHEST || priority == MONITOR;
            }
        }
        ,
        HIGHEST{

            @Override
            public boolean isLessThan(@NotNull Priority priority) {
                return priority == MONITOR;
            }
        }
        ,
        MONITOR{

            @Override
            public boolean isLessThan(@NotNull Priority priority) {
                return false;
            }
        };


        @Contract(pure=true)
        public abstract boolean isLessThan(@NotNull Priority var1);

        @Contract(pure=true)
        public boolean isGreaterThan(@NotNull Priority priority) {
            return !this.isLessThan(priority) && this != priority;
        }
    }
}

