/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.inventoryframework.gui.type.util;

import bending.libraries.inventoryframework.HumanEntityCache;
import bending.libraries.inventoryframework.gui.GuiListener;
import bending.libraries.inventoryframework.pane.Pane;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Gui {
    @NotNull
    protected final Plugin plugin;
    protected Inventory inventory;
    @NotNull
    protected final HumanEntityCache humanEntityCache = new HumanEntityCache();
    @Nullable
    protected Consumer<InventoryClickEvent> onTopClick;
    @Nullable
    protected Consumer<InventoryClickEvent> onBottomClick;
    @Nullable
    protected Consumer<InventoryClickEvent> onGlobalClick;
    @Nullable
    protected Consumer<InventoryClickEvent> onOutsideClick;
    @Nullable
    protected Consumer<InventoryDragEvent> onTopDrag;
    @Nullable
    protected Consumer<InventoryDragEvent> onBottomDrag;
    @Nullable
    protected Consumer<InventoryDragEvent> onGlobalDrag;
    @Nullable
    protected Consumer<InventoryCloseEvent> onClose;
    boolean updating = false;
    @Nullable
    private Gui parent;
    @NotNull
    private static final Map<Inventory, Gui> GUI_INVENTORIES = new WeakHashMap<Inventory, Gui>();
    private static boolean hasRegisteredListeners;

    public Gui(@NotNull Plugin plugin) {
        this.plugin = plugin;
        if (!hasRegisteredListeners) {
            Bukkit.getPluginManager().registerEvents((Listener)new GuiListener(plugin), plugin);
            hasRegisteredListeners = true;
        }
    }

    public abstract void show(@NotNull HumanEntity var1);

    @NotNull
    @Contract(pure=true)
    public abstract Gui copy();

    public abstract void click(@NotNull InventoryClickEvent var1);

    public abstract boolean isPlayerInventoryUsed();

    @Contract(pure=true)
    public abstract int getViewerCount();

    @NotNull
    @Contract(pure=true)
    public abstract List<HumanEntity> getViewers();

    public void update() {
        this.updating = true;
        for (HumanEntity viewer : this.getViewers()) {
            ItemStack cursor = viewer.getItemOnCursor();
            viewer.setItemOnCursor(new ItemStack(Material.AIR));
            this.show(viewer);
            viewer.setItemOnCursor(cursor);
        }
        if (!this.updating) {
            throw new AssertionError((Object)"Gui#isUpdating became false before Gui#update finished");
        }
        this.updating = false;
    }

    protected void addInventory(@NotNull Inventory inventory, @NotNull Gui gui) {
        GUI_INVENTORIES.put(inventory, gui);
    }

    @Nullable
    @Contract(pure=true)
    public static Gui getGui(@NotNull Inventory inventory) {
        return GUI_INVENTORIES.get(inventory);
    }

    @NotNull
    @Contract(pure=true)
    public HumanEntityCache getHumanEntityCache() {
        return this.humanEntityCache;
    }

    public void setOnTopClick(@Nullable Consumer<InventoryClickEvent> onTopClick) {
        this.onTopClick = onTopClick;
    }

    public void callOnTopClick(@NotNull InventoryClickEvent event) {
        this.callCallback(this.onTopClick, event, "onTopClick");
    }

    public void setOnBottomClick(@Nullable Consumer<InventoryClickEvent> onBottomClick) {
        this.onBottomClick = onBottomClick;
    }

    public void callOnBottomClick(@NotNull InventoryClickEvent event) {
        this.callCallback(this.onBottomClick, event, "onBottomClick");
    }

    public void setOnGlobalClick(@Nullable Consumer<InventoryClickEvent> onGlobalClick) {
        this.onGlobalClick = onGlobalClick;
    }

    public void callOnGlobalClick(@NotNull InventoryClickEvent event) {
        this.callCallback(this.onGlobalClick, event, "onGlobalClick");
    }

    public void setOnOutsideClick(@Nullable Consumer<InventoryClickEvent> onOutsideClick) {
        this.onOutsideClick = onOutsideClick;
    }

    public void callOnOutsideClick(@NotNull InventoryClickEvent event) {
        this.callCallback(this.onOutsideClick, event, "onOutsideClick");
    }

    public void setOnTopDrag(@Nullable Consumer<InventoryDragEvent> onTopDrag) {
        this.onTopDrag = onTopDrag;
    }

    public void callOnTopDrag(@NotNull InventoryDragEvent event) {
        this.callCallback(this.onTopDrag, event, "onTopDrag");
    }

    public void setOnBottomDrag(@Nullable Consumer<InventoryDragEvent> onBottomDrag) {
        this.onBottomDrag = onBottomDrag;
    }

    public void callOnBottomDrag(@NotNull InventoryDragEvent event) {
        this.callCallback(this.onBottomDrag, event, "onBottomDrag");
    }

    public void setOnGlobalDrag(@Nullable Consumer<InventoryDragEvent> onGlobalDrag) {
        this.onGlobalDrag = onGlobalDrag;
    }

    public void callOnGlobalDrag(@NotNull InventoryDragEvent event) {
        this.callCallback(this.onGlobalDrag, event, "onGlobalDrag");
    }

    public void setOnClose(@Nullable Consumer<InventoryCloseEvent> onClose) {
        this.onClose = onClose;
    }

    public void callOnClose(@NotNull InventoryCloseEvent event) {
        this.callCallback(this.onClose, event, "onClose");
    }

    protected <T extends InventoryEvent> void callCallback(@Nullable Consumer<? super T> callback, @NotNull T event, @NotNull String callbackName) {
        if (callback == null) {
            return;
        }
        try {
            callback.accept(event);
        }
        catch (Throwable t) {
            String message = "Exception while handling " + callbackName;
            if (event instanceof InventoryClickEvent) {
                InventoryClickEvent clickEvent = (InventoryClickEvent)event;
                message = message + ", slot=" + clickEvent.getSlot();
            }
            this.plugin.getLogger().log(Level.SEVERE, message, t);
        }
    }

    public void navigateToParent(@NotNull HumanEntity humanEntity) {
        if (this.parent == null) {
            return;
        }
        this.parent.show(humanEntity);
    }

    public void setParent(@NotNull Gui gui) {
        this.parent = gui;
    }

    @Contract(pure=true)
    public boolean isUpdating() {
        return this.updating;
    }

    public static void registerProperty(@NotNull String attributeName, @NotNull Function<String, Object> function) {
        Pane.registerProperty(attributeName, function);
    }
}

