/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.cloud.injection;

import bending.libraries.cloud.context.CommandContext;
import bending.libraries.cloud.injection.InjectionRequestImpl;
import bending.libraries.cloud.util.annotation.AnnotationAccessor;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.immutables.value.Value;

@API(status=API.Status.STABLE)
@Value.Immutable
public interface InjectionRequest<C> {
    public static <C> @NonNull InjectionRequest<C> of(@NonNull CommandContext<C> context, @NonNull TypeToken<?> injectedType, @NonNull AnnotationAccessor annotationAccessor) {
        return InjectionRequestImpl.of(context, injectedType, annotationAccessor);
    }

    public static <C> @NonNull InjectionRequest<C> of(@NonNull CommandContext<C> context, @NonNull TypeToken<?> injectedType) {
        return InjectionRequestImpl.of(context, injectedType, AnnotationAccessor.empty());
    }

    public @NonNull CommandContext<C> commandContext();

    public @NonNull TypeToken<?> injectedType();

    @Value.Derived
    default public @NonNull Class<?> injectedClass() {
        return GenericTypeReflector.erase((Type)this.injectedType().getType());
    }

    public @NonNull AnnotationAccessor annotationAccessor();
}

