/*
 * Decompiled with CFR 0.152.
 */
package me.moros.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.math.Position;
import me.moros.math.Rotation;
import me.moros.math.Vector3d;
import me.moros.math.Vector3i;

public final class VectorUtil {
    private static final Vector3d[] AXES = new Vector3d[]{Vector3d.PLUS_I, Vector3d.PLUS_J, Vector3d.PLUS_K, Vector3d.MINUS_I, Vector3d.MINUS_J, Vector3d.MINUS_K, ((Vector3d)Vector3d.PLUS_I.add(Vector3d.PLUS_K)).normalize(), ((Vector3d)Vector3d.PLUS_K.add(Vector3d.MINUS_I)).normalize(), ((Vector3d)Vector3d.MINUS_I.add(Vector3d.MINUS_K)).normalize(), ((Vector3d)Vector3d.MINUS_K.add(Vector3d.PLUS_I)).normalize()};

    private VectorUtil() {
    }

    public static Collection<Vector3d> createArc(Vector3d start, Vector3d axis, double angle, int rays) {
        Rotation rotation = Rotation.from(axis, angle);
        if ((rays = Math.max(3, rays)) % 2 == 0) {
            ++rays;
        }
        int half = (rays - 1) / 2;
        ArrayList<Vector3d> arc = new ArrayList<Vector3d>(rays);
        arc.add(start);
        arc.addAll(VectorUtil.rotate(start, rotation, half));
        arc.addAll(VectorUtil.rotateInverse(start, rotation, half));
        return arc;
    }

    public static Collection<Vector3d> circle(Vector3d start, Vector3d axis, int times) {
        double angle = Math.PI * 2 / (double)times;
        return VectorUtil.rotate(start, axis, angle, times);
    }

    public static Collection<Vector3d> rotate(Vector3d start, Vector3d axis, double angle, int times) {
        return VectorUtil.rotate(start, Rotation.from(axis, angle), times);
    }

    public static Collection<Vector3d> rotate(Vector3d start, Rotation rotation, int times) {
        ArrayList<Vector3d> arc = new ArrayList<Vector3d>();
        double[] vector = start.toArray();
        for (int i = 0; i < times; ++i) {
            rotation.applyTo(vector, vector);
            arc.add(Vector3d.from(vector));
        }
        return arc;
    }

    public static Collection<Vector3d> rotateInverse(Vector3d start, Vector3d axis, double angle, int times) {
        return VectorUtil.rotateInverse(start, Rotation.from(axis, angle), times);
    }

    public static Collection<Vector3d> rotateInverse(Vector3d start, Rotation rotation, int times) {
        ArrayList<Vector3d> arc = new ArrayList<Vector3d>();
        double[] vector = start.toArray();
        for (int i = 0; i < times; ++i) {
            rotation.applyInverseTo(vector, vector);
            arc.add(Vector3d.from(vector));
        }
        return arc;
    }

    public static Vector3d orthogonal(Vector3d axis, double radians, double length) {
        double[] arr = new double[]{axis.y(), -axis.x(), 0.0};
        Rotation rotation = Rotation.from(axis, radians);
        return rotation.applyTo((Position)Vector3d.from(arr).normalize().multiply(length));
    }

    public static Vector3d rotateAroundAxisX(Vector3d v, double cos, double sin) {
        return Vector3d.of(v.x(), v.y() * cos - v.z() * sin, v.y() * sin + v.z() * cos);
    }

    public static Vector3d rotateAroundAxisY(Vector3d v, double cos, double sin) {
        return Vector3d.of(v.x() * cos + v.z() * sin, v.y(), v.x() * -sin + v.z() * cos);
    }

    public static Vector3d rotateAroundAxisZ(Vector3d v, double cos, double sin) {
        return Vector3d.of(v.x() * cos - v.y() * sin, v.x() * sin + v.y() * cos, v.z());
    }

    public static Vector3d closestPoint(Vector3d start, Vector3d end, Vector3d target) {
        Vector3d toEnd = (Vector3d)end.subtract(start);
        double t = Math.clamp(((Vector3d)target.subtract(start)).dot(toEnd) / toEnd.dot(toEnd), 0.0, 1.0);
        return (Vector3d)start.add((Position)toEnd.multiply(t));
    }

    public static double distanceFromLine(Vector3d line, Vector3d pointOnLine, Vector3d point) {
        Vector3d temp = (Vector3d)point.subtract(pointOnLine);
        return temp.cross(line).length() / line.length();
    }

    public static Collection<Vector3i> decomposeDiagonals(Vector3d origin, Vector3d direction) {
        Vector3i temp = (Vector3i)((Vector3d)origin.add(direction)).toVector3i().subtract(origin.toVector3i());
        ArrayList<Vector3i> possibleCollisions = new ArrayList<Vector3i>(3);
        int delta = Math.clamp((long)temp.blockX(), -1, 1);
        if (delta != 0) {
            possibleCollisions.add(Vector3i.of(delta, 0, 0));
        }
        if ((delta = Math.clamp((long)temp.blockY(), -1, 1)) != 0) {
            possibleCollisions.add(Vector3i.of(0, delta, 0));
        }
        if ((delta = Math.clamp((long)temp.blockZ(), -1, 1)) != 0) {
            possibleCollisions.add(Vector3i.of(0, 0, delta));
        }
        if (possibleCollisions.isEmpty()) {
            return List.of(Vector3i.ZERO);
        }
        return possibleCollisions;
    }

    public static Vector3d gaussianOffset(Vector3d target, double offset) {
        return VectorUtil.gaussianOffset(target, offset, offset, offset);
    }

    public static Vector3d gaussianOffset(Vector3d target, double offsetX, double offsetY, double offsetZ) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        return (Vector3d)target.add(Vector3d.of(r.nextGaussian() * offsetX, r.nextGaussian() * offsetY, r.nextGaussian() * offsetZ));
    }

    public static Vector3d nearestFace(Vector3d dir) {
        Vector3d normal = dir.normalize();
        Vector3d result = AXES[0];
        double f = Double.MIN_VALUE;
        for (Vector3d face : AXES) {
            double g = normal.dot(face);
            if (!(g > f)) continue;
            f = g;
            result = face;
        }
        return result;
    }
}

