/*
 * Decompiled with CFR 0.152.
 */
package me.moros.math;

import me.moros.math.Position;
import me.moros.math.Vector3d;

public interface VectorOperations<T extends Position>
extends Position {
    default public double length() {
        return Math.sqrt(this.lengthSq());
    }

    default public double lengthSq() {
        return this.x() * this.x() + this.y() * this.y() + this.z() * this.z();
    }

    default public T withX(double value) {
        return this.add(value - this.x(), 0.0, 0.0);
    }

    default public T withY(double value) {
        return this.add(0.0, value - this.y(), 0.0);
    }

    default public T withZ(double value) {
        return this.add(0.0, 0.0, value - this.z());
    }

    default public T add(Position p) {
        return this.add(p.x(), p.y(), p.z());
    }

    public T add(double var1, double var3, double var5);

    default public T subtract(Position p) {
        return this.subtract(p.x(), p.y(), p.z());
    }

    default public T subtract(double dx, double dy, double dz) {
        return this.add(-dx, -dy, -dz);
    }

    default public T multiply(Position p) {
        return this.multiply(p.x(), p.y(), p.z());
    }

    default public T multiply(double a) {
        return this.multiply(a, a, a);
    }

    public T multiply(double var1, double var3, double var5);

    public T negate();

    public T cross(Position var1);

    default public double dot(Position p) {
        return this.x() * p.x() + this.y() * p.y() + this.z() * p.z();
    }

    default public double angle(Vector3d v) {
        double normProduct = this.length() * v.length();
        if (normProduct == 0.0) {
            return 0.0;
        }
        double dot = Math.min(Math.max(this.dot(v) / normProduct, -1.0), 1.0);
        return Math.acos(dot);
    }

    public T min(Position var1);

    public T max(Position var1);

    public T abs();

    public T floor();

    public T clampVelocity();
}

