/*
 * Decompiled with CFR 0.152.
 */
package me.moros.math;

import me.moros.math.FastMath;
import me.moros.math.IntPoint;
import me.moros.math.Position;
import me.moros.math.VectorOperations;
import me.moros.math.adapter.Adapters;

public interface Vector3i
extends VectorOperations<Vector3i> {
    public static final Vector3i ZERO = Vector3i.of(0, 0, 0);
    public static final Vector3i ONE = Vector3i.of(1, 1, 1);
    public static final Vector3i PLUS_I = Vector3i.of(1, 0, 0);
    public static final Vector3i MINUS_I = Vector3i.of(-1, 0, 0);
    public static final Vector3i PLUS_J = Vector3i.of(0, 1, 0);
    public static final Vector3i MINUS_J = Vector3i.of(0, -1, 0);
    public static final Vector3i PLUS_K = Vector3i.of(0, 0, 1);
    public static final Vector3i MINUS_K = Vector3i.of(0, 0, -1);

    @Override
    default public double x() {
        return this.blockX();
    }

    @Override
    default public double y() {
        return this.blockY();
    }

    @Override
    default public double z() {
        return this.blockZ();
    }

    @Override
    default public Vector3i toVector3i() {
        return this;
    }

    @Override
    default public Vector3i add(double dx, double dy, double dz) {
        return Vector3i.of(this.x() + dx, this.y() + dy, this.z() + dz);
    }

    @Override
    default public Vector3i multiply(double ax, double ay, double az) {
        return Vector3i.of(ax * this.x(), ay * this.y(), az * this.z());
    }

    @Override
    default public Vector3i negate() {
        return Vector3i.of(-this.blockX(), -this.blockY(), -this.blockZ());
    }

    @Override
    default public Vector3i cross(Position v) {
        int newX = this.blockY() * v.blockZ() - v.blockY() * this.blockZ();
        int newY = this.blockZ() * v.blockX() - v.blockZ() * this.blockX();
        int newZ = this.blockX() * v.blockY() - v.blockX() * this.blockY();
        return Vector3i.of(newX, newY, newZ);
    }

    @Override
    default public Vector3i min(Position v) {
        return Vector3i.of(Math.min(this.blockX(), v.blockX()), Math.min(this.blockY(), v.blockY()), Math.min(this.blockZ(), v.blockZ()));
    }

    @Override
    default public Vector3i max(Position v) {
        return Vector3i.of(Math.max(this.blockX(), v.blockX()), Math.max(this.blockY(), v.blockY()), Math.max(this.blockZ(), v.blockZ()));
    }

    @Override
    default public Vector3i abs() {
        return Vector3i.of(Math.abs(this.blockX()), Math.abs(this.blockY()), Math.abs(this.blockZ()));
    }

    @Override
    default public Vector3i floor() {
        return this;
    }

    @Override
    default public Vector3i clampVelocity() {
        int clampedX = Math.clamp((long)this.blockX(), -4, 4);
        int clampedY = Math.clamp((long)this.blockY(), -4, 4);
        int clampedZ = Math.clamp((long)this.blockZ(), -4, 4);
        return Vector3i.of(clampedX, clampedY, clampedZ);
    }

    default public Adapters<Vector3i> adapters() {
        return Adapters.vector3i();
    }

    public static Vector3i of(int x, int y, int z) {
        return new IntPoint(x, y, z);
    }

    public static Vector3i of(double x, double y, double z) {
        return Vector3i.of(FastMath.floor(x), FastMath.floor(y), FastMath.floor(z));
    }

    public static Vector3i from(int[] v) throws IllegalArgumentException {
        if (v.length != 3) {
            throw new IllegalArgumentException();
        }
        return Vector3i.of(v[0], v[1], v[2]);
    }

    public static <T> Vector3i from(T object) {
        return Adapters.vector3i().adapt(object);
    }
}

