/*
 * Decompiled with CFR 0.152.
 */
package me.moros.math;

import me.moros.math.Vector3d;
import me.moros.math.Vector3i;
import me.moros.math.adapter.Adapters;

public interface Position {
    public double x();

    public double y();

    public double z();

    public int blockX();

    public int blockY();

    public int blockZ();

    default public double distance(Position v) {
        return Math.sqrt(this.distanceSq(v));
    }

    default public double distanceSq(Position v) {
        double dx = v.x() - this.x();
        double dy = v.y() - this.y();
        double dz = v.z() - this.z();
        return dx * dx + dy * dy + dz * dz;
    }

    default public Vector3i toVector3i() {
        return Vector3i.of(this.blockX(), this.blockY(), this.blockZ());
    }

    default public Vector3d toVector3d() {
        return Vector3d.of(this.x(), this.y(), this.z());
    }

    default public Vector3d center() {
        return Vector3d.of((double)this.blockX() + 0.5, (double)this.blockY() + 0.5, (double)this.blockZ() + 0.5);
    }

    default public <T> T to(Class<T> nativeType) {
        return (T)this.adapters().converter(nativeType).apply(this);
    }

    default public double[] toArray() {
        return new double[]{this.x(), this.y(), this.z()};
    }

    default public int[] toIntArray() {
        return new int[]{this.blockX(), this.blockY(), this.blockZ()};
    }

    default public double minComponent() {
        return Math.min(this.x(), Math.min(this.y(), this.z()));
    }

    default public double maxComponent() {
        return Math.max(this.x(), Math.max(this.y(), this.z()));
    }

    public Adapters<? extends Position> adapters();
}

