/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.protection.plugin;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.domains.Association;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.protection.AbstractProtection;
import me.moros.bending.paper.platform.PlatformAdapter;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public final class WorldGuardProtection
extends AbstractProtection {
    private final WorldGuard worldGuard = WorldGuard.getInstance();
    private final StateFlag bendingFlag = (StateFlag)this.worldGuard.getFlagRegistry().get("bending");

    public WorldGuardProtection(Plugin plugin) {
        super(plugin.getName());
    }

    @Override
    public boolean canBuild(LivingEntity entity, Block block) {
        StateFlag flagToCheck;
        RegionQuery query = this.worldGuard.getPlatform().getRegionContainer().createQuery();
        World w = PlatformAdapter.toBukkitWorld(block.world());
        com.sk89q.worldedit.util.Location location = BukkitAdapter.adapt((Location)new Location(w, (double)block.blockX(), (double)block.blockY(), (double)block.blockZ()));
        StateFlag stateFlag = flagToCheck = this.bendingFlag == null ? Flags.BUILD : this.bendingFlag;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(PlatformAdapter.toBukkitEntity(player));
            if (this.worldGuard.getPlatform().getSessionManager().hasBypass(localPlayer, localPlayer.getWorld())) {
                return true;
            }
            return query.testState(location, localPlayer, new StateFlag[]{flagToCheck});
        }
        return query.testState(location, list -> Association.NON_MEMBER, new StateFlag[]{flagToCheck});
    }
}

