/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.platform.world;

import io.papermc.paper.math.Position;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.raytrace.BlockRayTrace;
import me.moros.bending.api.collision.raytrace.CompositeRayTrace;
import me.moros.bending.api.collision.raytrace.Context;
import me.moros.bending.api.collision.raytrace.RayTrace;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.platform.particle.ParticleContext;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.util.data.DataHolder;
import me.moros.bending.paper.platform.BukkitDataHolder;
import me.moros.bending.paper.platform.PlatformAdapter;
import me.moros.bending.paper.platform.block.LockableImpl;
import me.moros.bending.paper.platform.particle.ParticleMapper;
import me.moros.math.Vector3d;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lockable;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.metadata.Metadatable;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.Nullable;

public record BukkitWorld(org.bukkit.World handle) implements World
{
    @Override
    public BlockType getBlockType(int x, int y, int z) {
        return BlockType.registry().getIfExists(this.handle().getType(x, y, z).key()).orElse(BlockType.VOID_AIR);
    }

    @Override
    public me.moros.bending.api.platform.block.BlockState getBlockState(int x, int y, int z) {
        return PlatformAdapter.fromBukkitData(this.handle().getBlockData(x, y, z));
    }

    @Override
    public AABB blockBounds(int x, int y, int z) {
        org.bukkit.block.Block b = this.handle().getBlockAt(x, y, z);
        BoundingBox box = b.getBoundingBox();
        if (box.getVolume() == 0.0 || !b.isCollidable()) {
            return AABB.dummy();
        }
        Vector3d min = Vector3d.of(box.getMinX(), box.getMinY(), box.getMinZ());
        Vector3d max = Vector3d.of(box.getMaxX(), box.getMaxY(), box.getMaxZ());
        return AABB.of(min, max);
    }

    @Override
    public DataHolder blockMetadata(int x, int y, int z) {
        return new BukkitDataHolder((Metadatable)this.handle().getBlockAt(x, y, z));
    }

    @Override
    public boolean isBlockEntity(me.moros.math.Position position) {
        BlockState state = this.handle().getBlockAt(position.blockX(), position.blockY(), position.blockZ()).getState(false);
        return state instanceof TileState;
    }

    @Override
    public @Nullable me.moros.bending.api.platform.block.Lockable containerLock(me.moros.math.Position position) {
        BlockState container = this.handle().getBlockAt(position.blockX(), position.blockY(), position.blockZ()).getState(false);
        if (container instanceof Lockable) {
            Lockable lockable = (Lockable)container;
            return new LockableImpl(lockable);
        }
        return null;
    }

    @Override
    public boolean setBlockState(int x, int y, int z, me.moros.bending.api.platform.block.BlockState state) {
        this.handle().setBlockData(x, y, z, PlatformAdapter.toBukkitData(state));
        return true;
    }

    @Override
    public List<me.moros.bending.api.platform.entity.Entity> nearbyEntities(AABB box, Predicate<me.moros.bending.api.platform.entity.Entity> predicate, int limit) {
        Vector min = new Vector(box.min().x(), box.min().y(), box.min().z());
        Vector max = new Vector(box.max().x(), box.max().y(), box.max().z());
        BoundingBox bb = BoundingBox.of((Vector)min, (Vector)max);
        ArrayList<me.moros.bending.api.platform.entity.Entity> entities = new ArrayList<me.moros.bending.api.platform.entity.Entity>();
        for (Entity bukkitEntity : this.handle().getNearbyEntities(bb)) {
            me.moros.bending.api.platform.entity.Entity entity = PlatformAdapter.fromBukkitEntity(bukkitEntity);
            if (!predicate.test(entity)) continue;
            entities.add(entity);
            if (limit <= 0 || entities.size() < limit) continue;
            return entities;
        }
        return entities;
    }

    @Override
    public String name() {
        return this.handle().getName();
    }

    @Override
    public int minHeight() {
        return this.handle().getMinHeight();
    }

    @Override
    public int maxHeight() {
        return this.handle().getMaxHeight();
    }

    @Override
    public <T> void spawnParticle(ParticleContext<T> context) {
        Particle p = (Particle)Registry.PARTICLE_TYPE.get(PlatformAdapter.nsk(context.particle().key()));
        if (p != null) {
            Object data = ParticleMapper.mapParticleData(context);
            this.handle().spawnParticle(p, context.position().x(), context.position().y(), context.position().z(), context.count(), context.offset().x(), context.offset().y(), context.offset().z(), context.extra(), data, true);
        }
    }

    @Override
    public BlockRayTrace rayTraceBlocks(Context context) {
        Location loc = new Location(this.handle(), context.origin().x(), context.origin().y(), context.origin().z());
        Vector dir = new Vector(context.dir().x(), context.dir().y(), context.dir().z());
        FluidCollisionMode mode = context.ignoreLiquids() ? FluidCollisionMode.NEVER : FluidCollisionMode.ALWAYS;
        Predicate<org.bukkit.block.Block> canCollide = b -> !context.ignore(b.getX(), b.getY(), b.getZ());
        RayTraceResult result = this.handle().rayTraceBlocks((Position)loc, dir, context.range(), mode, context.ignorePassable(), canCollide);
        if (result == null || result.getHitBlock() == null) {
            return RayTrace.miss(context.endPoint());
        }
        Vector pos = result.getHitPosition();
        Vector3d point = Vector3d.of(pos.getX(), pos.getY(), pos.getZ());
        Block block = this.blockAt(result.getHitBlock().getX(), result.getHitBlock().getY(), result.getHitBlock().getZ());
        return RayTrace.hit(point, block);
    }

    @Override
    public CompositeRayTrace rayTraceEntities(Context context, double range) {
        Vector start = new Vector(context.origin().x(), context.origin().y(), context.origin().z());
        Vector dir = new Vector(context.dir().x(), context.dir().y(), context.dir().z());
        AABB box = AABB.fromRay(context.origin(), context.dir(), context.raySize());
        BoundingBox bb = new BoundingBox(box.min().x(), box.min().y(), box.min().z(), box.max().x(), box.max().y(), box.max().z());
        me.moros.bending.api.platform.entity.Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity bukkitEntity : this.handle().getNearbyEntities(bb)) {
            double distanceSq;
            BoundingBox boundingBox;
            RayTraceResult hitResult;
            me.moros.bending.api.platform.entity.Entity entity = PlatformAdapter.fromBukkitEntity(bukkitEntity);
            if (!context.entityPredicate().test(entity) || (hitResult = (boundingBox = bukkitEntity.getBoundingBox().expand(context.raySize())).rayTrace(start, dir, range)) == null || !((distanceSq = start.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        if (nearestHitEntity == null) {
            return RayTrace.miss(context.endPoint());
        }
        Vector pos = nearestHitResult.getHitPosition();
        return RayTrace.hit(Vector3d.of(pos.getX(), pos.getY(), pos.getZ()), nearestHitEntity);
    }

    @Override
    public boolean isDay() {
        return this.handle().getEnvironment() == World.Environment.NORMAL && this.handle().isDayTime();
    }

    @Override
    public boolean isNight() {
        return this.handle().getEnvironment() == World.Environment.NORMAL && !this.handle().isDayTime();
    }

    @Override
    public me.moros.bending.api.platform.entity.Entity createEntity(me.moros.math.Position pos, me.moros.bending.api.platform.entity.EntityType type) {
        EntityType bukkitType = (EntityType)Registry.ENTITY_TYPE.get(PlatformAdapter.nsk(type.key()));
        Class entityType = bukkitType == null ? null : bukkitType.getEntityClass();
        return this.create(Objects.requireNonNull(entityType), pos);
    }

    private <T extends Entity> me.moros.bending.api.platform.entity.Entity create(Class<T> entityClass, me.moros.math.Position pos) {
        Location loc = new Location(this.handle(), pos.x(), pos.y(), pos.z());
        return PlatformAdapter.fromBukkitEntity(this.handle().createEntity(loc, entityClass));
    }

    @Override
    public boolean addEntity(me.moros.bending.api.platform.entity.Entity entity) {
        Entity bukkitEntity = PlatformAdapter.toBukkitEntity(entity);
        if (bukkitEntity.isInWorld()) {
            return false;
        }
        this.handle().addEntity(bukkitEntity);
        return true;
    }

    @Override
    public boolean breakNaturally(int x, int y, int z) {
        return this.handle.getBlockAt(x, y, z).breakNaturally();
    }

    @Override
    public me.moros.bending.api.platform.entity.Entity dropItem(me.moros.math.Position pos, ItemSnapshot item, boolean canPickup) {
        Location loc = new Location(this.handle(), pos.x(), pos.y(), pos.z());
        Item droppedItem = this.handle().dropItem(loc, PlatformAdapter.toBukkitItem(item));
        droppedItem.setPersistent(false);
        droppedItem.setCanMobPickup(canPickup);
        droppedItem.setCanPlayerPickup(canPickup);
        return PlatformAdapter.fromBukkitEntity((Entity)droppedItem);
    }

    @Override
    public me.moros.bending.api.platform.entity.Entity createFallingBlock(me.moros.math.Position pos, me.moros.bending.api.platform.block.BlockState state, boolean gravity) {
        Location loc = new Location(this.handle(), pos.x(), pos.y(), pos.z());
        BlockData data = PlatformAdapter.toBukkitData(state);
        FallingBlock bukkitEntity = (FallingBlock)this.handle().spawn(loc, FallingBlock.class, fb -> {
            fb.setBlockData(data);
            fb.setGravity(gravity);
            fb.setDropItem(false);
        });
        return PlatformAdapter.fromBukkitEntity((Entity)bukkitEntity);
    }

    @Override
    public int lightLevel(int x, int y, int z) {
        return this.handle().getBlockAt(x, y, z).getLightLevel();
    }

    @Override
    public int blockLightLevel(int x, int y, int z) {
        return this.handle().getBlockAt(x, y, z).getLightFromBlocks();
    }

    @Override
    public int skyLightLevel(int x, int y, int z) {
        return this.handle().getBlockAt(x, y, z).getLightFromSky();
    }

    @Override
    public World.Dimension dimension() {
        return switch (this.handle().getEnvironment()) {
            default -> throw new MatchException(null, null);
            case World.Environment.NORMAL -> World.Dimension.OVERWORLD;
            case World.Environment.NETHER -> World.Dimension.NETHER;
            case World.Environment.THE_END -> World.Dimension.END;
            case World.Environment.CUSTOM -> World.Dimension.CUSTOM;
        };
    }

    @Override
    public CompletableFuture<?> loadChunkAsync(int x, int z) {
        return this.handle().getChunkAtAsync(x, z);
    }

    @Override
    public int viewDistance() {
        return this.handle().getViewDistance();
    }

    public Iterable<? extends Audience> audiences() {
        return this.handle().audiences();
    }

    public Key key() {
        return this.handle().key();
    }
}

