/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.platform.item;

import java.util.Objects;
import me.moros.bending.api.platform.item.EquipmentSlot;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.platform.item.PlayerInventory;
import me.moros.bending.paper.platform.PlatformAdapter;
import me.moros.bending.paper.platform.item.BukkitInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BukkitPlayerInventory
extends BukkitInventory
implements PlayerInventory {
    private final org.bukkit.inventory.PlayerInventory handle;

    public BukkitPlayerInventory(Player player) {
        super(player.getEquipment());
        this.handle = player.getInventory();
    }

    @Override
    public int selectedSlot() {
        return this.handle.getHeldItemSlot();
    }

    @Override
    public boolean has(Item type, int amount) {
        return this.handle.contains(PlatformAdapter.toBukkitItemMaterial(type), amount);
    }

    @Override
    public void offer(ItemSnapshot item) {
        ItemStack bukkitItem = PlatformAdapter.toBukkitItem(item);
        int leftover = this.handle.addItem(new ItemStack[]{bukkitItem}).size();
        if (leftover > 0) {
            bukkitItem.setAmount(leftover);
            HumanEntity player = Objects.requireNonNull(this.handle.getHolder());
            player.getWorld().dropItemNaturally(player.getEyeLocation().subtract(0.0, 0.3, 0.0), bukkitItem);
        }
    }

    @Override
    public boolean remove(Item type, int amount) {
        if (!this.has(type, amount)) {
            return false;
        }
        ItemStack bukkitItem = PlatformAdapter.toBukkitItem(type);
        bukkitItem.setAmount(amount);
        ItemStack toReturn = this.handle.removeItemAnySlot(new ItemStack[]{bukkitItem}).values().stream().findAny().orElse(null);
        if (toReturn != null) {
            this.handle.addItem(new ItemStack[]{toReturn});
            return false;
        }
        return true;
    }

    @Override
    public void dropItem(EquipmentSlot slot) {
        Objects.requireNonNull(this.handle.getHolder()).dropItem(BukkitPlayerInventory.toBukkit(slot));
    }
}

